package wzorceproj.posrednik.gumomatmonitor;

public class StanGumaSprzedana implements Stan {
	private static final long serialVersionUID = 2L;
    AutomatSprzedający automatSprzedający;
 
    public StanGumaSprzedana(AutomatSprzedający automatSprzedający) {
        this.automatSprzedający = automatSprzedający;
    }
       
	public void włóżMonetę() {
		System.out.println("Proszę czekać na gumę");
	}
 
	public void zwróćMonetę() {
		System.out.println("Niestety, nie można zwrócić monety po przekręceniu gałki");
	}
 
	public void przekręćGałkę() {
		System.out.println("Nie dostaniesz gumy tylko dlatego, że przekręciłeś drugi raz!");
	}
 
	public void wydaj() {
		automatSprzedający.zwolnijGumę();
		try {
			if (automatSprzedający.pobierzLiczba() > 0) {
				automatSprzedający.ustawStan(automatSprzedający.pobierzStanNieMaMonety());
			} else {
				System.out.println("Ups, koniec gum!");
				automatSprzedający.ustawStan(automatSprzedający.pobierzStanBrakGum());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
 
	public String toString() {
		return "wydawanie gumy";
	}
}
