package wzorceproj.polecenie.superpilotlambda;

public class ProgramowaniePilota {
 
   public static void main(String[] args) {
      SuperPilot pilot = new SuperPilot();
 
      Światło jadalniaŚwiatło = new Światło("Jadalnia");
      Światło kuchniaŚwiatło = new Światło("Kuchnia");
      WentylatorSufitowy wentylatorSufitowy= new WentylatorSufitowy("Jadalnia");
      DrzwiGarażowe drzwiGarażowe = new DrzwiGarażowe("Garaż");
      WieżaStereo wieżaStereo = new WieżaStereo("Jadalnia");
 
      pilot.ustawPolecenie(0, () -> jadalniaŚwiatło.włącz(), 
                              () -> jadalniaŚwiatło.wyłącz() );
      /* 
       * Alternatywny sposób zapisu
      pilot.ustawPolecenie(0, jadalniaŚwiatło::włącz, 
                              jadalniaŚwiatło::wyłącz );
      */

      pilot.ustawPolecenie(1, () -> kuchniaŚwiatło.włącz(), 
                              () -> kuchniaŚwiatło.wyłącz() );
      pilot.ustawPolecenie(2, () -> wentylatorSufitowy.wysokieObroty(), 
                              () -> wentylatorSufitowy.wyłącz());
      pilot.ustawPolecenie(3, () -> wieżaStereo.ustawCD(), 
                              () -> wieżaStereo.wyłącz());
  
      System.out.println(pilot);
 
      pilot.wciśniętoPrzyciskWłącz(0);
      pilot.wciśniętoPrzyciskWyłącz(0);
      pilot.wciśniętoPrzyciskWłącz(1);
      pilot.wciśniętoPrzyciskWyłącz(1);
      pilot.wciśniętoPrzyciskWłącz(2);
      pilot.wciśniętoPrzyciskWyłącz(2);
      pilot.wciśniętoPrzyciskWłącz(3);
      pilot.wciśniętoPrzyciskWyłącz(3);
   }
}
