package wzorceproj.obserwator.prostyobserwator;

import java.util.Observable;
import java.util.Observer;
	
public class ProstyObserwator implements Observer {
	private int wartość;
	private Observable obserwowalny;
	
	public ProstyObserwator(Observable obserwowalny) {
		this.obserwowalny = obserwowalny;
		obserwowalny.addObserver((Observer) this);
	}
	
	public void wyświetl() {
		System.out.println("Wartość: " + wartość);
	}

	@Override
	public void update(Observable o, Object arg) {
		System.out.println(arg);
		this.wartość = (int) arg;
		wyświetl();
		if (o instanceof ProstyPodmiot) {
			ProstyPodmiot simpleSubject = (ProstyPodmiot)o;
			this.wartość = simpleSubject.pobierzWartość();
			wyświetl();
		}
	}
}
