package wzorceproj.singleton.podwojneblokowanie;

//
// Uwaga!  Ta implementacja singletonu może nie działać 
// w razie stosowania Javy starszej do wersji Java 5!
//

public class Singleton {
	private volatile static Singleton unikalnaInstancja;
 
	private Singleton() {}
 
	public static Singleton pobierzInstancję() {
		if (unikalnaInstancja == null) {
			synchronized (Singleton.class) {
				if (unikalnaInstancja == null) {
					unikalnaInstancja = new Singleton();
				}
			}
		}
		return unikalnaInstancja;
	}
}
