package wzorceproj.posrednik.javaproxy;

import java.lang.reflect.*;
import java.util.*;

public class SerwisSwatajacyTest {
   HashMap<String, Osoba> swatanieBD = new HashMap<String, Osoba>();
    
   public static void main(String[] args) {
      SerwisSwatajacyTest test = new SerwisSwatajacyTest();
      test.testuj();
   }
 
   public SerwisSwatajacyTest() {
      inicjalizacjaBazyDanych();
   }

   public void testuj() {
      Osoba jaś = pobierzOsobęZBazyDanych("Jan Fasoliński"); 
      Osoba pośrednikWłaściciela = pobierzPośrednikWłaściciela(jaś);
      System.out.println("Imię to " + pośrednikWłaściciela.pobierzImię());
      pośrednikWłaściciela.ustawZainteresowania("kręgle, go");
      System.out.println("Pośrednik właściciela ustawił wartość zainteresowania");
      try {
         pośrednikWłaściciela.ustawRankingPasji(10);
      } catch (Exception e) {
         System.out.println("Nie można zmieniać oceny przy użyciu pośrednika właściciela");
      }
      System.out.println("Wartość rankingu to " + pośrednikWłaściciela.pobierzRankingPasji());

      Osoba pośrednikNieWłaściciela = pobierzPośrednikNieWłaściciela(jaś);
      System.out.println("\nImię to " + pośrednikNieWłaściciela.pobierzImię());
      try {
         pośrednikNieWłaściciela.ustawZainteresowania("kręgle, go");
      } catch (Exception e) {
         System.out.println("Nie można zmieniać zainteresowań przy użyciu pośrednika właściciela");
      }
      pośrednikNieWłaściciela.ustawRankingPasji(3);
      System.out.println("Pośrednik obcy zmienił wartość rankingu");
      System.out.println("Wartość rankingu to " + pośrednikNieWłaściciela.pobierzRankingPasji());
   }

   Osoba pobierzPośrednikWłaściciela(Osoba osoba) {
       
        return (Osoba) Proxy.newProxyInstance( 
               osoba.getClass().getClassLoader(),
               osoba.getClass().getInterfaces(),
                new InvocationHandlerWłaściciela(osoba));
   }

   Osoba pobierzPośrednikNieWłaściciela(Osoba osoba) {
      
        return (Osoba) Proxy.newProxyInstance(
               osoba.getClass().getClassLoader(),
               osoba.getClass().getInterfaces(),
                new InvocationHandlerNieWłaściciela(osoba));
   }

   Osoba pobierzOsobęZBazyDanych(String name) {
      return (Osoba)swatanieBD.get(name);
   }

   void inicjalizacjaBazyDanych() {
      Osoba jaś = new OsobaImpl();
      jaś.ustawImię("Jan Fasoliński");
      jaś.ustawZainteresowania("samochody, komputery, muzyka");
      jaś.ustawRankingPasji(7);
      swatanieBD.put(jaś.pobierzImię(), jaś);

      Osoba klemantyna = new OsobaImpl();
      klemantyna.ustawImię("Klementyna Domykalska");
      klemantyna.ustawZainteresowania("aukcje, filmy, muzyka");
      klemantyna.ustawRankingPasji(6);
      swatanieBD.put(klemantyna.pobierzImię(), klemantyna);
   }
}
