package wzorceproj.most.pilot;

public abstract class Pilot {
	Telewizor tv;
	FabrykaTelewizorów tvFactory;
	public Pilot(FabrykaTelewizorów tvFactory) {
		this.tvFactory = tvFactory;
	}
	public void włącz() {
		this.tv.włącz();
	}
	public void wyłącz() {
		this.tv.wyłącz();
	}
	public void ustawKanał(int channel) {
		tv.tuneChannel(channel);
	}
	public int pobierzKanał() {
		return tv.pobierzKanał();
	}
	public void ustawTelewizor(String type) {
		try {
			tv = tvFactory.pobierzTelewizor(type);
		} catch (Exception e) {
			System.out.println(e);
		}
	}
}