package wzorceproj.kompozyt.menuiterator;

import java.util.Iterator;
import java.util.ArrayList;

public class Menu extends MenuSkładnik {
	Iterator<MenuSkładnik> iterator = null;
	ArrayList<MenuSkładnik> menuSkładniki = new ArrayList<MenuSkładnik>();
	String nazwa;
	String opis;
  
	public Menu(String nazwa, String opis) {
		this.nazwa = nazwa;
		this.opis = opis;
	}
 
	public void dodaj(MenuSkładnik menuSkładnik) {
		menuSkładniki.add(menuSkładnik);
	}
 
	public void usuń(MenuSkładnik menuSkładnik) {
		menuSkładniki.remove(menuSkładnik);
	}
 
	public MenuSkładnik pobierzPotomek(int i) {
		return menuSkładniki.get(i);
	}
 
	public String pobierzNazwa() {
		return nazwa;
	}
 
	public String pobierzOpis() {
		return opis;
	}

  
	public Iterator<MenuSkładnik> utwórzIterator() {
		if (iterator == null) {
			iterator = new IteratorZłożony(menuSkładniki.iterator());
		}
		return iterator;
	}
 
 
	public void drukuj() {
		System.out.print("\n" + pobierzNazwa());
		System.out.println(", " + pobierzOpis());
		System.out.println("---------------------");
  
		Iterator<MenuSkładnik> iterator = menuSkładniki.iterator();
		while (iterator.hasNext()) {
			MenuSkładnik menuComponent = iterator.next();
			menuComponent.drukuj();
		}
	}
}
