package wzorceproj.iterator.laczeniebiznesowobiadmania;

import java.util.*;

public class ObiadManiaMenu implements Menu {
   Map<String, PozycjaMenu> pozycjeMenu = new HashMap<String, PozycjaMenu>();
  
   public ObiadManiaMenu() {
      dodajElement("Kanapka wegetariańska z frytkami",
         "Kanapka wegetariańska z sałatą i pomidorem, frytki",
         true, 11.59);
      dodajElement("Zupa dnia",
         "Miseczka zupy dnia, sałatka",
         false, 14.89);
      dodajElement("Burito",
         "Duże burito z łaciatą fasolą, sosem salsa i guacamole",
         true, 17.29);
   }
 
   public void dodajElement(String nazwa, String opis, 
                        boolean wegetariańska, double cena) 
   {
      PozycjaMenu pozycjaMenu = new PozycjaMenu(nazwa, opis, wegetariańska, cena);
      pozycjeMenu.put(nazwa, pozycjaMenu);
   }
 
   public Map<String, PozycjaMenu> pobierzPozycjeMenu() {
      return pozycjeMenu;
   }
  
   public Iterator<PozycjaMenu> utwórzIterator() {
      return pozycjeMenu.values().iterator();
   }
}
