package wzorceproj.iterator.laczeniebiznesowi;

import java.util.Iterator;

public class ObiadowoMenu implements Menu {
   static final int MAX_LICZBA_ELEMENTÓW = 6;
   int liczbaElementów = 0;
   PozycjaMenu[] pozycjeMenu;
  
   public ObiadowoMenu() {
      pozycjeMenu = new PozycjaMenu[MAX_LICZBA_ELEMENTÓW];
 
      dodajElement("Wegetariańska kanapka BSP",
         "(Wegetariański) boczek z sałatą i pomidorem, chleb pszenny pełnoziarnisty", true, 12.99);
      dodajElement("Kanapka BSP",
         "Boczek z sałatą i pomidorem, chleb pszenny pełnoziarnisty", false, 12.99);
      dodajElement("Zupa dnia",
         "Zupa dnia i sałatka z pomidora", false, 15.19);
      dodajElement("Hot dog",
         "Hot dog z kiszoną kapustą, rzodkiewką, cebulą i dodatkiem sera",
         false, 16.05);
      dodajElement("Warzywa na parze i brązowy ryż",
         "Mieszanka warzyw gotowanych na parze i porcja pełnowartościowego ryżu", true, 16.99);
      dodajElement("Makaron",
         "Spaghetti z sosem marinara i kromką chleba na zakwasie",
         true, 17.89);
   }
  
   public void dodajElement(String nazwa, String opis, 
                        boolean wegetariańska, double cena) 
   {
      PozycjaMenu pozycjaMenu = new PozycjaMenu(nazwa, opis, wegetariańska, cena);
      if (liczbaElementów >= MAX_LICZBA_ELEMENTÓW) {
         System.err.println("Niestety, menu jest pełne! Nie można dodać nowej pozycji");
      } else {
         pozycjeMenu[liczbaElementów] = pozycjaMenu;
         liczbaElementów = liczbaElementów + 1;
      }
   }
 
   public PozycjaMenu[] pobierzPozycjeMenu() {
      return pozycjeMenu;
   }
  
   public Iterator<PozycjaMenu> utwórzIterator() {
      return new ObiadowoMenuIterator(pozycjeMenu);
      //return new WymienneObiadowoMenuIterator(pozycjeMenu);
   }
 
   // Inne metody klasy menu
}
