package wzorceproj.budowniczy.wakacje;

import java.time.LocalDate;

public class WakacjeLuxBudowniczy extends BudowniczyPlanu {	
	public WakacjeLuxBudowniczy() {
		this.nazwa = "Budowniczy luksusowych wakacji stacjonarnych";
	}
	public BudowniczyPlanu dodajZakwaterowanie() {
		this.zakwaterowania.add(new Hotel());
		return this;
	}
	public BudowniczyPlanu dodajZakwaterowanie(String nazwa) {
		this.zakwaterowania.add(new Hotel(nazwa));
		return this;
	}
	public BudowniczyPlanu dodajZakwaterowanie(String nazwa, int rok, int miesiąc, int dzień, int liczbaNocy, int lokalizacja) {
		Rezerwacja reservation = new Rezerwacja();
		reservation.ustawDatęPrzyjazdu(rok, miesiąc, dzień);
		reservation.ustawLiczbęNocy(liczbaNocy);
		
		Hotel hotel = new Hotel(nazwa);
		hotel.ustawRezerwację(reservation);
		hotel.ustawNumerPokoju(lokalizacja);
		this.zakwaterowania.add(hotel);
		return this;
	}
	public BudowniczyPlanu dodajAtrakcję(String event) {
		this.atrakcje.add("Wieczorne przedstawienie: " + event + ".");
		return this;
	}
}