## Rozdział 3. - Kreacyjne wzorce projektowe 
```bash
# Metoda wytwórcza: tworzenie instancji 
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/metoda_wytworcza -sourcepath java -d out/Rozdzial03/metoda_wytworcza ./Rozdzial03/metoda_wytworcza/*.java
$ java --enable-preview -cp out/Rozdzial03/metoda_wytworcza FactoryMethodMain
$ java --enable-preview -cp out/Rozdzial03/metoda_wytworcza -XX:StartFlightRecording=filename=FactoryMethod.jfr,dumponexit-true,settings=profile FactoryMethodMain

# Fabryka abstrakcyjna: tworzenie fabryki do tworzenia odpowiednich instancji
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/fabryka_abstrakcyjna -sourcepath java -d out/Rozdzial03/fabryka_abstrakcyjna ./Rozdzial03/fabryka_abstrakcyjna/*.java
$ java --enable-preview -cp out/Rozdzial03/fabryka_abstrakcyjna AbstractFactoryMain

# Budowniczy
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/budowniczy -sourcepath java -d out/Rozdzial03/budowniczy ./Rozdzial03/budowniczy/*.java
$ java --enable-preview -cp out/Rozdzial03/budowniczy BuilderMain

# Prototyp
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/prototyp -sourcepath java -d out/Rozdzial03/prototyp ./Rozdzial03/prototyp/*.java
$ java --enable-preview -cp out/Rozdzial03/prototyp PrototypeMain

# Singleton 
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/singleton -sourcepath java -d out/Rozdzial03/singleton ./Rozdzial03/singleton/*.java
$ java --enable-preview -cp out/Rozdzial03/singleton SingletonMain


# Pula obiektów
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/pula_obiektow -sourcepath java -d out/Rozdzial03/pula_obiektow ./Rozdzial03/pula_obiektow/*.java
$ java --enable-preview -cp out/Rozdzial03/pula_obiektow ObjectPoolMain

# Leniwa inicjalizacja
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/leniwa_inicjalizacja -sourcepath java -d out/Rozdzial03/leniwa_inicjalizacja ./Rozdzial03/leniwa_inicjalizacja/*.java
$ java --enable-preview -cp out/Rozdzial03/leniwa_inicjalizacja LazyInitializationMain

# Wstrzykiwanie zależności
$ javac --release 17 --enable-preview -g -cp out/Rozdzial03/wstrzykiwanie_zaleznosci -sourcepath java -d out/Rozdzial03/wstrzykiwanie_zaleznosci ./Rozdzial03/wstrzykiwanie_zaleznosci/*.java
$ java --enable-preview -cp out/Rozdzial03/wstrzykiwanie_zaleznosci DependencyInjectionMain

### konieczne jest umieszczenie w CLASSPATH kondiguracji dostawców usług
$ cp -R Rozdzial03/wstrzykiwanie_zaleznosci/META-INF  out/Rozdzial03/wstrzykiwanie_zaleznosci
$ java --enable-preview -cp out/Rozdzial03/wstrzykiwanie_zaleznosci DependencyInjectionServiceLoaderMain
```
