## Rozdział 1. - Wprowadzenie do wzorców projektowych oprogramowania
 1. **APDH** - filary **programowania zorientowanego obiektowo** (**OOP**):
    - Hermetyzacja (H) : 
        - [Przykład 1.1 - `Vehicle.java`](./apdh/Vehicle.java)
    - Dziedziczenie (D)
        - [klasa `Car.java` rozszerzająca klasę `Vehicle`](./apdh/Car.java)
        - [klasa `SportCar.java` rozszerzająca klasę `AbstractVehicle`](./apdh/SportCar.java)
    - Polimorfizm (P)
        - przeciążanie metod
            - [Rysunek 1.5 - klasa `Vehicle`](./apdh/Vehicle.java)
        - przesłanianie metod
            - [Przykład 1.2, Rysunek 1.6 - klasa `Vehicle`](./apdh/Vehicle.java)
            - [Przykład 1.2, Rysunek 1.6 - klasa `Car`](./apdh/Car.java)
    - Abstrakcja (A)
        - klasy abstrakcyjne
            - [Przykład 1.3, Rysunek 1.7 - klasa `AbstractVehicle`](./apdh/AbstractVehicle.java)
            - [Przykład 1.3, Rysunek 1.7 - klasa `CommonCar`](./apdh/CommonCar.java)
            - [Przykład 1.3, Rysunek 1.7 - klasa `SportCar`](./apdh/SportCar.java)
        - interfejsy
            - [Przykład 1.4, Rysunek 1.8 - klasa `VehicleInterface`](./apdh/VehicleInterface.java)
            - [Przykład 1.4, Rysunek 1.8 - klasa `Truck`](./apdh/Truck.java)
            - [Przykład 1.4, Rysunek 1.8 - klasa `Bus`](./apdh/Bus.java) 
        - klasy abstrakcyjne i interfejsy
            - [Rysunek 1.9 - klasa `VehicleInterface`](./apdh/VehicleInterface.java)
            - [Rysunek 1.9 - klasa `AbstractVehicle`](./apdh/AbstractVehicle.java)
            - [Rysunek 1.9 - klasa `Truck`](./apdh/CommonCar.java)
            - [Rysunek 1.9 - klasa `Bus`](./apdh/SportCar.java) 


 2. Zasady SOLID 
    - zasada jednej odpowiedzialności (SRP)
        - [Rysunek 1.12 - klasa `Vehicle`](./solid/srp/Vehicle.java)
        - [Rysunek 1.12 - klasa `Engine`](./solid/srp/Engine.java)
        - [Rysunek 1.12 - klasa `VehicleComputer`](./solid/srp/VehicleComputer.java)
    - zasada otwarte-zamknięte (OCP)
        - [Przykład 1.5 - klasa `Vehicle`](./solid/ogolne/Vehicle.java)
        - [Przykład 1.5 - klasa `Truck`](./solid/ogolne/Truck.java)
        - [Przykład 1.6 - klasa `Example1_6Main`](./solid/ogolne/Example1_6Main.java)
    - zasada podstawienia Liskov (LSP)
        - [Przykład 1.7 - klasa `Vehicle`](./solid/ogolne/Vehicle.java)
        - [Przykład 1.7 - klasa `CarWash`](./solid/ogolne/CarWash.java)
        - [Przykład 1.7 - klasa `Car`](./solid/ogolne/Car.java)
        - [Przykład 1.7 - klasa `SportCar`](./solid/ogolne/SportCar.java)
        - [Przykład 1.7 - `klasa Example1_7Main.java`](./solid/ogolne/Example1_7Main.java)
    - zasada segregacji interfejsów (ISP)
        - błędna
            - [Przykład 1.8 - klasa `Vehicle`](./solid/spi_bledna/Vehicle.java)
            - [Przykład 1.8 - klasa `Bike`](./solid/spi_bledna/Bike.java)
            - [Przykład 1.8 - klasa `Car`](./solid/spi_bledna/Car.java)
            - [Przykład 1.8 - klasa `Example1_8Main`](./solid/spi_bledna/Example1_8Main.java)
        - optymalna
            - [Przykład 1.9 - klasa `Vehicle`](./solid/spi_optymalna/Vehicle.java)
            - [Przykład 1.9 - klasa `Bike`](./solid/spi_optymalna/Bike.java)
            - [Przykład 1.9 - klasa `Car`](./solid/spi_optymalna/Car.java)
            - [Przykład 1.9 - klasa `HasEngine`](./solid/spi_optymalna/HasEngine.java)
            - [Przykład 1.9 - klasa `HasPedals`](./solid/spi_optymalna/HasPedals.java)
            - [Przykład 1.9 - klasa `Example1_8Main`](./solid/spi_optymalna/Example1_9Main.java)
    - zasada odwrócenia zależności (DIP)
        - [Przykład 1.10 - klasa `Gerage`](./solid/dip/Garage.java)

### Przykłady wykonywalne:
```bash
# Przykład 1.2:
$ javac --release 17 --enable-preview -g -cp out/Rozdzial01/apdh/ -sourcepath java -d out/Rozdzial01/apdh ./Rozdzial01/apdh/*.java
$ java --enable-preview -cp out/Rozdzial01/apdh Example1_2Main

# Przykład 1.6 oraz przykład 1.7
$ javac --release 17 --enable-preview -g -cp out/Rozdzial01/solid/ogolne/ -sourcepath java -d out/Rozdzial01/solid/ogolne ./Rozdzial01/solid/ogolne/*.java
$ java --enable-preview -cp out/Rozdzial01/solid/ogolne Example1_6Main
$ java --enable-preview -cp out/Rozdzial01/solid/ogolne Example1_7Main

# Przykład 1.8: SPI - błędna
$ javac --release 17 --enable-preview -g -cp out/Rozdzial01/solid/spi_bledna/ -sourcepath java -d out/Rozdzial01/solid/spi_bledna ./Rozdzial01/solid/spi_bledna/*.java
$ java --enable-preview -cp out/Rozdzial01/solid/spi_bledna Example1_8Main

# Przykład 1.9: SPI - optymalna
$ javac --release 17 --enable-preview -g -cp out/Rozdzial01/solid/spi_optymalna/ -sourcepath java -d out/Rozdzial01/solid/spi_optymalna ./Rozdzial01/solid/spi_optymalna/*.java
$ java --enable-preview -cp out/Rozdzial01/solid/spi_optymalna Example1_9Main
