import java.util.ArrayList;
import java.util.List;

class FilterMain {
    private static final List<Sensor> vehicleSensors = new ArrayList<>();
    static {
        vehicleSensors.add(new Sensor("paliwa", true));
        vehicleSensors.add(new Sensor("paliwa", false));
        vehicleSensors.add(new Sensor("prędkości", false));
        vehicleSensors.add(new Sensor("prędkości", true));
    }
    public static void main(String[] args) {
        System.out.println("Wzorzec Filtr, czujniki pojazdów");
        Rule analog = new RuleAnalog();
        Rule speedSensor = new RuleType("prędkości");

        System.out.println("AnalogSensors: " + analog.validateSensors(vehicleSensors));
        System.out.println("SpeedSensors: " + speedSensor.validateSensors(vehicleSensors));

        var analogAndSpeedSensors = new RuleAnd(analog, speedSensor);
        var analogOrSpeedSensors = new RuleOr(analog, speedSensor);
        System.out.println("analogAndSpeedSensors=" + analogAndSpeedSensors.validateSensors(vehicleSensors));
        System.out.println("analogOrSpeedSensors=" + analogOrSpeedSensors.validateSensors(vehicleSensors));
    }
}
