class Vehicle {
    private final Engine engine;

    Vehicle(Engine engine) {
        this.engine = engine;
    }

    public void drive(){
        System.out.println("Vehicle, jedzie");
        engine.run();
    }

    public void refuel(){
        System.out.println("Vehicle, zatrzymany");
        switch (engine){
            case ElectricEngine de -> {
                System.out.println("Pojazd wymaga naładowania silnika");
                de.checkPlug();
                de.tank();
            }
            case PetrolEngine pe -> {
                System.out.println("Pojazd wymaga zatankowania paliwa");
                pe.tank();

            }
            default -> throw new IllegalStateException("W pojeździe brak silnika");
        }
    }
}
