
### Tworzenie i otwieranie zapisów Java Flight Recorder

Projekt zawiera kilka zapisów ***.jfr***. W nazwach plików został umieszczony numer rysunku stworzonego przy użyciu danego zapisu. Do stworzenia tych rysunków użyłem program **Java Mission Control v 8.2**. Pliki *.jfr można otwierać przy użyciu aplikacji **Java Mission Control**, którą można pobrać ze stron WWW wymienionych poniżej.

Odnośniki do pobierania:
- https://github.com/openjdk/jmc
- https://adoptium.net/jmc/

```bash 
# Uruchamianie JavaFlightRecorder na potrzeby wzroców
# Rejestrowano z użyciem Java 17
$ java -XX:StartFlightRecording=filename=<PATTERN_NAME_MAIN>.jfr,dumponexit=true,settings=profile <MAIN_CLASS>
```

## Rozdział 6. - Wzorce projektowe współbieżności
```bash
# Aktywny obiekt 
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/aktywny_obiekt -sourcepath java -d out/Rozdzial06/aktywny_obiekt ./Rozdzial06/aktywny_obiekt/*.java
$ java --enable-preview -cp out/Rozdzial06/aktywny_obiekt ActiveObjectMain

# Asynchroniczne wywołanie metody 
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/asynch_wywolanie_metody -sourcepath java -d out/Rozdzial06/asynch_wywolanie_metody ./Rozdzial06/asynch_wywolanie_metody/*.java
$ java --enable-preview -cp out/Rozdzial06/asynch_wywolanie_metody AsyncMethodMain

# Wzorzec Balking
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/balking -sourcepath java -d out/Rozdzial06/balking ./Rozdzial06/balking/*.java
$ java --enable-preview -cp out/Rozdzial06/balking BalkingMain

# Podwójnie sprawdzane blokowanie
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/podwojnie_sprawdzane_blokowanie -sourcepath java -d out/Rozdzial06/podwojnie_sprawdzane_blokowanie ./Rozdzial06/podwojnie_sprawdzane_blokowanie/*.java
$ java --enable-preview -cp out/Rozdzial06/podwojnie_sprawdzane_blokowanie DoubleCheckedLockingMain

# Blokada odczytu-zapisu
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/blokada_odczytu_zapisu -sourcepath java -d out/Rozdzial06/blokada_odczytu_zapisu ./Rozdzial06/blokada_odczytu_zapisu/*.java
$ java --enable-preview -cp out/Rozdzial06/blokada_odczytu_zapisu ReadWriteLockMain

# Producent-konsument
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/producent_konsument -sourcepath java -d out/Rozdzial06/producent_konsument ./Rozdzial06/producent_konsument/*.java
$ java --enable-preview -cp out/Rozdzial06/producent_konsument ProducerConsumerMain

# Dyspozytor
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/dyspozytor -sourcepath java -d out/Rozdzial06/dyspozytor ./Rozdzial06/dyspozytor/*.java

$ java --enable-preview -cp out/Rozdzial06/dyspozytor CustomSchedulerMain
$ java --enable-preview -cp out/Rozdzial06/dyspozytor CustomScheduledThreadPoolMain

# Pula wątków
$ javac --release 17 --enable-preview -g -cp out/Rozdzial06/pula_watkow -sourcepath java -d out/Rozdzial06/pula_watkow ./Rozdzial06/pula_watkow/*.java
$ java --enable-preview -cp out/Rozdzial06/pula_watkow ThreadPoolMain
```
