class VehicleController {
    private final RequestDispatcher dispatcher;
    private boolean authorized;

    VehicleController() {
        this.dispatcher = new RequestDispatcher(new BreaksUnit(), new EngineUnit());
    }

    private boolean isAuthorized() {
        System.out.println("VehicleController, czy autoryzowano");
        return authorized;
    }

    private void logRequest(String request) {
        System.out.printf("""
                VehicleController, dziennik: '%s'%n""", request);
    }

    void authorize() {
        System.out.println("VehicleController, autoryzowano");
        authorized = true;
    }

    void processRequest(String request) {
        logRequest(request);
        if (isAuthorized()) {
            dispatcher.dispatch(request);
        } else {
            System.out.printf("""
                VehicleController, nieautoryzowane żądanie: '%s'%n""", request);
        }
    }
}
