<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|    example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|    http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|    $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|    $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "welcome";
$route['404_override'] = '';

// custom routes

$route['register'] = 'users/register';
$route['login'] = 'users/login';
$route['logout'] = 'users/logout';
$route['search'] = 'users/search';
$route['profile'] = 'users/profile';
$route['settings'] = 'users/settings';
$route['friend/(:num)'] = 'users/friend/$1';
$route['unfriend/(:num)'] = 'users/unfriend/$1';
$route['users/edit/(:num)'] = 'users/edit/$1';
$route['users/delete/(:num)'] = 'users/delete/$1';
$route['users/undelete/(:num)'] = 'users/undelete/$1';
$route['fonts/(:any)'] = 'files/fonts/$1';
$route['thumbnails/(:num)'] = 'files/thumbnails/$1';
$route['files/delete/(:num)'] = 'files/delete/$1';
$route['files/undelete/(:num)'] = 'files/undelete/$1';

/* End of file routes.php */
/* Location: ./application/config/routes.php */