<?php

class MY_Controller extends CI_Controller
{
    public $user;
        
    public static function redirect($url)
    {
        header("Location: {$url}");
        exit();
    }
    
    protected function _isSecure()
    {
        // pobranie sesji użytkownika
        $this->_getUser();
        
        if (!$this->user)
        {
            self::redirect("/login");
        }
    }
    
    protected function _getUser()
    {
        // load session library
        $this->load->library("session");
        
        // pobranie identyfikatora użytkownika
        $id = $this->session->userdata("user");
        
        if ($id)
        {
            // load user model
            $this->load->model("user");
            
            // pobranie użytkownika
            $this->user = new User(array(
                "id" => $id
            ));
        }
    }
}