<?php

$post = function($url, $data)
{
    $request = new Framework\Request();
    return $request->post("http://".$_SERVER["HTTP_HOST"]."/{$url}", $data);
};

Framework\Test::add(
    function() use ($post)
    {
        $html = $post(
            "register.html",
            array(
                "first" => "Hello",
                "last" => "World",
                "email" => "info@example.com",
                "password" => "password",
                "register" => "register"
            )
        );
        
        return (stristr($html, "Twoje konto zostało założone!"));
    },
    "Formularz rejestracji tworzy użytkownika",
    "Functions/Users"
);

Framework\Test::add(
    function() use ($post)
    {
        $html = $post(
            "login.html",
            array(
                "email" => "info@example.com",
                "password" => "password",
                "login" => "login"
            )
        );
        
        return (stristr($html, "Location: /profile.html"));
    },
    "Formularz logowania tworzy sesję użytkownika i przekierowuje do profilu",
    "Functions/Users"
);