<?php

class UsersController extends Zend_Controller_Action
{
    public $user;
        
    public static function redirect($url)
    {
        header("Location: {$url}");
        exit();
    }
    
    protected function _isSecure()
    {
        // pobranie sesji użytkownika
        $this->_getUser();
        
        if (!$this->user)
        {
            self::redirect("/login");
        }
    }
    
    protected function _getUser()
    {
        // inicjacja sesji
        $session = new Zend_Session_Namespace("application");
        
        // pobranie identyfikatora użytkownika
        $id = $session->user;
        
        if ($id)
        {
            // pobranie użytkownika
            $this->user = Application_Model_User::first(array("id = ?" => $id));
        }
    }

    protected function _upload($name, $user)
    {
        // pobranie rozszerzenia
        $time = time();
        $path = dirname(APPLICATION_PATH)."/public/uploads/";
        $filename = "{$user}-{$time}";

        // utworzenie egzemplarza klasy obsługi przesyłania plików
        $adapter = new Zend_File_Transfer_Adapter_Http(array(
            "useByteString" => false
        ));
        $adapter->setDestination($path);
        
        if ($adapter->receive())
        {
            // pobranie danych pliku
            $size = $adapter->getFileSize($name);
            $file = $adapter->getFileName($name);

            // dodanie rozszerzenia do nazwy pliku
            $parts = explode(".", $file);
            $filename .= ".".end($parts);

            if (rename($file, "{$path}/{$filename}"))
            {
                // pobranie rozmiaru i typu MIME pliku
                $dimensions = getimagesize("{$path}/{$filename}");

                // utworzenie i zapisanie nowego pliku
                $file = new Application_Model_File(array(
                    "name" => $filename,
                    "mime" => $dimensions["mime"],
                    "size" => $size,
                    "width" => $dimensions[0],
                    "height" => $dimensions[1],
                    "user" => $user
                ));
                
                $file->save();
            }
        }
    }

    protected function _thumbnail($file)
    {
        $path = dirname(APPLICATION_PATH)."/public/uploads";
        
        $width = 64;
        $height = 64;
        
        $name = $file->name;
        $filename = pathinfo($name, PATHINFO_FILENAME);
        $extension = pathinfo($name, PATHINFO_EXTENSION);
        
        if ($filename && $extension)
        {
            $thumbnail = "{$filename}-{$width}x{$height}.{$extension}";
            
            if (!file_exists("{$path}/{$thumbnail}"))
            { 
                $imagine = new Imagine\Gd\Imagine();
                
                $size = new Imagine\Image\Box($width, $height);
                $mode = Imagine\Image\ImageInterface::THUMBNAIL_OUTBOUND;
                
                $imagine
                    ->open("{$path}/{$name}")
                    ->thumbnail($size, $mode)
                    ->save("{$path}/{$thumbnail}");
            }
            
            return $thumbnail;
        }

    }

    public function registerAction()
    {
        $valid = true;
        $errors = array();
        $success = false;

        $first = $this->_request->getPost("first");
        $last = $this->_request->getPost("last");
        $email = $this->_request->getPost("email");
        $password = $this->_request->getPost("password");
        
        // jeśli formularz został wysłany
        if ($this->_request->getPost("save"))
        {
            // egzekucja zasad weryfikacji danych

            $alnum = new Zend_Validate_Alnum();
            $stringLength1 = new Zend_Validate_StringLength(array("min" => 3, "max" => 32));
            $stringLength2 = new Zend_Validate_StringLength(array("min" => 0, "max" => 255));

            if (empty($first) || !$alnum->isValid($first) || !$stringLength1->isValid($first))
            {
                $valid = false;
                $errors["first"] = "Pierwsze pole jest wymagane";
            }

            if (empty($last) || !$alnum->isValid($last) || !$stringLength1->isValid($last))
            {
                $valid = false;
                $errors["last"] = "Ostatnie pole jest wymagane";
            }

            if (empty($email) || !$stringLength2->isValid($email))
            {
                $valid = false;
                $errors["email"] = "Pole e-mail jest wymagane";
            }

            if (empty($password) || !$stringLength2->isValid($password))
            {
                $valid = false;
                $errors["password"] = "Pole hasła jest wymagane";
            }
            
            // jeśli dane formularza są poprawne
            if ($valid)
            {
                // utworzenie i zapisanie nowego użytkownika
                $user = new Application_Model_User(array(
                    "first" => $first,
                    "last" => $last,
                    "email" => $email,
                    "password" => $password
                ));
                $id = $user->save();

                $this->_upload("photo", $id);
                
                // sygnał o powodzeniu do widoku
                $success = true;
            }
        }
        
        // załadowanie widoku
        $this->view->errors = $errors;
        $this->view->success = $success;
    }

    public function loginAction()
    {
        $valid = true;
        $errors = array();

        $email = $this->_request->getPost("email");
        $password = $this->_request->getPost("password");
        
        // jeśli formularz został wysłany
        if ($this->_request->getPost("login"))
        {
            // egzekucja zasad weryfikacji danych

            $alnum = new Zend_Validate_Alnum();
            $stringLength = new Zend_Validate_StringLength(array("min" => 0, "max" => 255));

            if (empty($email) || !$stringLength->isValid($email))
            {
                $valid = false;
                $errors["email"] = "Pole e-mail jest wymagane";
            }

            if (empty($password) || !$stringLength->isValid($password))
            {
                $valid = false;
                $errors["password"] = "Pole hasła jest wymagane";
            }
            
            // jeśli dane formularza są poprawne
            if ($valid)
            {
                $user = Application_Model_User::first(array(
                    "email = ?" => $email,
                    "password = ?" => $password
                ));

                if ($user)
                {
                    // inicjacja sesji
                    $session = new Zend_Session_Namespace("application");
                    
                    // zapisanie identyfikatora użytkownika w sesji
                    $session->user = $user->id;
                    
                    // przekierowanie na stronę profilu
                    $this->_helper->redirector->gotoRoute(array(
                       "controller" => "users",
                       "action" => "profile"
                    ));
                    
                }
                else
                {
                    // informacja o błędach
                    $errors["password"] = "Niepoprawny adres e-mail lub niewłaściwe hasło";
                }
            }
        }
        
        // załadowanie widoku
        $this->view->errors = $errors;
    }

    public function logoutAction()
    {
        // odblokowanie sesji
        $session = new Zend_Session_Namespace("application");
        $session->unlock();

        // zakończenie sesji
        Zend_Session::namespaceUnset("application");
        
        // przekierowanie do logowania
        self::redirect("/login");
    }
    
    public function profileAction()
    {
        // sprawdzenie czy istnieje sesja użytkownika
        $this->_isSecure();

        // załadowanie miniatury
        $file = Application_Model_File::first(array(
            "user = ?" => $this->user->id
        ));
        
        // załadowanie widoku
        $this->view->user = $this->user;

        if ($file)
        {
            $filename = $this->_thumbnail($file);
            $this->view->filename = $filename;
        }
    }

    public function settingsAction()
    {
        // sprawdzenie czy istnieje sesja użytkownika
        $this->_isSecure();

        $valid = true;
        $errors = array();
        $success = false;

        $first = $this->_request->getPost("first");
        $last = $this->_request->getPost("last");
        $email = $this->_request->getPost("email");
        $password = $this->_request->getPost("password");
        
        // jeśli formularz został wysłany
        if ($this->_request->getPost("save"))
        {
            // egzekucja zasad weryfikacji danych

            $alnum = new Zend_Validate_Alnum();
            $stringLength1 = new Zend_Validate_StringLength(array("min" => 3, "max" => 32));
            $stringLength2 = new Zend_Validate_StringLength(array("min" => 0, "max" => 255));

            if (empty($first) || !$alnum->isValid($first) || !$stringLength1->isValid($first))
            {
                $valid = false;
                $errors["first"] = "Pierwsze pole jest wymagane";
            }

            if (empty($last) || !$alnum->isValid($last) || !$stringLength1->isValid($last))
            {
                $valid = false;
                $errors["last"] = "Ostatnie pole jest wymagane";
            }

            if (empty($email) || !$stringLength2->isValid($email))
            {
                $valid = false;
                $errors["email"] = "Pole e-mail jest wymagane";
            }

            if (empty($password) || !$stringLength2->isValid($password))
            {
                $valid = false;
                $errors["password"] = "Pole hasła jest wymagane";
            }
            
            // jeśli dane formularza są poprawne
            if ($valid)
            {
                // zapisanie zmian danych użytkownika
                $this->user->first = $first;
                $this->user->last = $last;
                $this->user->email = $email;
                $this->user->password = $password;
                $this->user->save();
                
                // sygnał o powodzeniu do widoku
                $success = true;
            }
        }
        
        // załadowanie widoku
        $this->view->errors = $errors;
        $this->view->success = $success;
        $this->view->user = $this->user;
    }
    
    public function searchAction()
    {
        // pobranie wysłanych danych
        $query = $this->_request->getPost("query");
        $order = $this->_request->getPost("order");
        $direction = $this->_request->getPost("direction");
        $page = $this->_request->getPost("page");
        $limit = $this->_request->getPost("limit");
        
        // domyślne wartości null
        $order = $order ? $order : "modified";
        $direction = $direction ? $direction : "desc";
        $limit = $limit ? $limit : 10;
        $page = $page ? $page : 1;
        $count = 0;
        $users = null;
        
        if ($this->_request->getPost("search"))
        {
            $where = array(
                "first = ?" => $query,
                "live = ?" => 1,
                "deleted = ?" => 0
            );
            
            $fields = array(
                "id", "first", "last"
            );
            
            // pobranie liczby i wyników
            $count = Application_Model_User::count($where);
            $users = Application_Model_User::all(
                $where,
                $fields,
                $order,
                $direction,
                $limit,
                $page
            );
        }
        
        // załadowanie widoku
        $this->view->query = $query;
        $this->view->order = $order;
        $this->view->direction = $direction;
        $this->view->page = $page;
        $this->view->limit = $limit;
        $this->view->count = $count;
        $this->view->users = $users;
    }
}

