#include <iostream>
#include <gtest/gtest.h>

class Connection {
public:
  Connection(const std::string& /*url*/) {
    std::cout << "Utworzono połączenie" << '\n';
  }
  ~Connection() {
    std::cout << "Usunięto połączenie" << '\n';
  }
  //...
};

auto close(Connection& /*connection*/) {
  //...
}

auto open_connection(const std::string& url) {
  return Connection{url};
}


auto send_request(Connection& /*connection*/, const std::string& /*message*/) {
  // ...
}

class RAIIConnection {
public:
  RAIIConnection(const std::string& url)
    : connection_{open_connection(url)} {}
  ~RAIIConnection() {
    try {
      close(connection_);
    }
    catch (const std::exception&) {
      // Obsługa błędów, przy czym destruktor nigdy nie powinien zgłaszać wyjątków.
    }
  }

  auto& get() {
    return connection_;
  }

private:
  Connection connection_;
};

auto send(const std::string& message) {
  auto connection = RAIIConnection("http://www.example.com/");
  send_request(connection.get(), message);
  // Nie trzeba zamykać połączenia. Destruktor klasy RAIIConnection 
  // robi to automatycznie.
}

TEST(RaiiConnection, SendMessage) {
  send("komunikat");
  send("inny komunikat");
}
