#include "chapter_12.h"
#ifdef SUPPORTS_COROUTINES

#include <gtest/gtest.h>

#include "resumable.h"

#include <limits>

auto coroutine() -> Resumable {            // Początkowe wstrzymanie.
  std::cout << "3 ";
  co_await std::suspend_always{};  // Wstrzymanie (bezpośrednie).
  std::cout << "5 ";
}                                  


TEST(ResumableMinimalExample, ResumeCoroutine) {
  std::cout << "1 ";
  auto resumable = coroutine(); // Tworzenie stanu korutyny.
  std::cout << "2 ";
  resumable.resume();           // Wznawianie.
  std::cout << "4 ";
  resumable.resume();           // Wznawianie.
  std::cout << "6 ";
}                               // Usuwanie stanu korutyny.
// Wyświetla: 1 2 3 4 5 6

#endif // SUPPORTS_COROUTINES