// Na razie nieobsługiwane w kompilatorach
#include <version>

#if defined(__cpp_lib_atomic_wait) && defined(__cpp_lib_atomic_flag_test)

#include <gtest/gtest.h>

#include <atomic>
#include <iostream>
#include <random>
#include <thread>

namespace SpinLock {

class SimpleMutex {
  std::atomic_flag is_locked{}; // Domyślnie flaga jest wyzerowana.
public:
  auto lock() noexcept {
    while (is_locked.test_and_set()) {
      while (is_locked.test()) // C++20
        ;                      // Tu blokada "wiruje"
    }
  }
  auto unlock() noexcept { is_locked.clear(); }
};

TEST(Atomics, SimpleSpinLock) {

  constexpr auto n = 1'000'000;
  auto counter = 0; // Zmienna counter jest zabezpieczona muteksem
  auto counter_mutex = SimpleMutex{};

  auto increment_counter = [&] {
    for (int i = 0; i < n; ++i) {
      counter_mutex.lock();
      ++counter;
      counter_mutex.unlock();
    }
  };

  auto t1 = std::thread{increment_counter};
  auto t2 = std::thread{increment_counter};

  t1.join(); // Można też użyć wątku std::jthread
  t2.join();

  std::cout << counter << '\n';
  // Jeśli nie wystąpiła sytuacja wyścigu, asercja powinna być prawdziwa
  ASSERT_EQ(n * 2, counter);
}

} // namespace SpinLock

namespace WaitAndNotify {

class SimpleMutex {
  std::atomic_flag is_locked{};

public:
  auto lock() noexcept {
    while (is_locked.test_and_set())
      is_locked.wait(true); // Oczekiwanie bez „wirowania”.
  }

  auto unlock() noexcept {
    is_locked.clear();
    is_locked.notify_one(); // Powiadamianie zablokowanego wątku.
  }
};

TEST(Atomics, WaitAndNotify) {

  constexpr auto n = 1000000;
  auto counter = 0; // Zmienna counter jest zabezpieczona muteksem.
  auto counter_mutex = SimpleMutex{};

  auto increment_counter = [&] {
    for (int i = 0; i < n; ++i) {
      counter_mutex.lock();
      ++counter;
      counter_mutex.unlock();
    }
  };

  auto t1 = std::thread{increment_counter};
  auto t2 = std::thread{increment_counter};
  t1.join();
  t2.join();

  std::cout << counter << '\n';
  // Jeśli nie wystąpiła sytuacja wyścigu, asercja powinna być prawdziwa
  ASSERT_EQ(n * 2, counter);
}

} // namespace WaitAndNotify

#endif // atomic_wait && atomic_notify