#include <iostream>
#include <sstream>
#include <string>
#include <tuple>

#include <gtest/gtest.h>

template <size_t Index, typename TupleType, typename Functor>
auto tuple_at(const TupleType& tpl, const Functor& func) -> void {
  const auto& val = std::get<Index>(tpl);
  func(val);
}

template <typename TupleType, typename Functor, size_t Index = 0>
auto tuple_for_each(const TupleType& tpl, const Functor& ifunctor) -> void {
  constexpr auto tuple_size = std::tuple_size_v<TupleType>;
  if constexpr (Index < tuple_size) {
    tuple_at<Index>(tpl, ifunctor);
    tuple_for_each<TupleType, Functor, Index + 1>(tpl, ifunctor);
  }
}

// Tworzy łańcuch znaków z jednego argumentu
template <typename T> auto make_string(const T& v0) -> std::string {
  auto sstr = std::ostringstream{};
  sstr << v0;
  return sstr.str();
}

// Tworzy łańcuch znaków z dwóch argumentów
template <typename T0, typename T1>
auto make_string(const T0& v0, const T1& v1) -> std::string {
  return make_string(v0) + " " + make_string(v1);
}

// Tworzy łańcuch znaków z trzech argumentów
template <typename T0, typename T1, typename T2>
auto make_string(const T0& v0, const T1& v1, const T2& v2) -> std::string {
  return make_string(v0, v1) + " " + make_string(v2);
}

// Tworzy łańcuch znaków z czterech argumentów
template <typename T0, typename T1, typename T2, typename T3>
auto make_string(const T0& v0, const T1& v1, const T2& v2, const T3& v3)
    -> std::string {
  return make_string(v0, v1, v2) + " " + make_string(v3);
}

template <typename... Ts> auto expand_pack(const Ts&... values) {
  auto tuple = std::tie(values...);
}

template <typename... Ts> auto make_string(const Ts&... values) {
  auto sstr = std::ostringstream{};
  // Tworzenie krotki na podstawie wariadycznej grupy parametrów
  auto tuple = std::tie(values...);
  // Iteracyjne pobieranie elementów krotki
  tuple_for_each(tuple, [&sstr](const auto& v) { sstr << v; });
  return sstr.str();
}

TEST(VariadicTemplateParameterPack, MakeString) {
  // Bez wariadycznej grupy parametrów
  auto str1 = make_string(42);
  ASSERT_EQ("42", str1);

  auto str2 = make_string(42, "cześć");
  ASSERT_EQ("42 cześć", str2);

  auto str3 = make_string(42, "cześć", true);
  ASSERT_EQ("42 cześć 1", str3);

  auto str4 = make_string(42, "cześć", true, false);
  ASSERT_EQ("42 cześć 1 0", str4);

  // Z użyciem wariadycznej grupy parametrów
  auto str5 = make_string(42, "cześć", true, false, 42.0f);
  ASSERT_EQ("42cześć1042", str5);
}
