#include <gtest/gtest.h>

#include <iostream>

namespace {

struct Bear {
  auto roar() const { std::cout << "mrr, mrr\n"; }
};
struct Duck {
  auto quack() const { std::cout << "kwa, kwa\n"; }
};

// Funkcji speak nie można używać razem z klasami Bear lub Duck
template <typename Animal> 
auto speak(const Animal& a) {
  if (std::is_same_v<Animal, Bear>) {
    a.roar();
  } else if (std::is_same_v<Animal, Duck>) {
    a.quack();
  }
}

template <typename Animal> 
void constexpr_if_speak(const Animal& a) {
  if constexpr (std::is_same_v<Animal, Bear>) {
    a.roar();
  } else if constexpr (std::is_same_v<Animal, Duck>) {
    a.quack();
  }
}

} // namespace

TEST(ConstexprIfAnimals, Speak) {
  Bear bear;
  Duck duck;

  constexpr_if_speak(bear);
  constexpr_if_speak(duck);

  // Nie skompiluje się, ponieważ nie użyto constexpr_if
  // speak(bear);
  // speak(duck);
}
