#include <iostream>
#include <gtest/gtest.h>

// Implementację operatorów new() i delete() znajdziesz w pliku operator_new.cpp.
extern size_t allocated;

auto print_string_mem(const char* chars) {
  allocated = 0;
  auto s = std::string(chars);
  std::cout << "Pamięć na stosie = " << sizeof(s)
    << ", pamięć na stercie = " << allocated
    << ", pojemność = " << s.capacity() << '\n';
}

class SmallSizeOptimization : public ::testing::Test {
protected:
  void SetUp() override {
    allocated = 0;
  }
};

TEST_F(SmallSizeOptimization, StringMemory) {
   // Sprawdzanie dla łańcuchów znaków o różnej długości
  print_string_mem("");
  print_string_mem("1234567890123456789012");
  print_string_mem("12345678901234567890123");
}
