#include <cassert>
#include <gtest/gtest.h>
#include <vector>

//
// Ten kod pokazuje, że C++ pozwala zminimalizować
// liczbę alokacji na stercie dzięki:
// 1) Tworzeniu obiektów na stosie
// 2) Alokowaniu wielu obiektów w jednej operacji alokacji na stercie
//

struct Car {
  int doors_{};
};

auto some_func() {
  auto num_doors = 2;
  auto car1 = Car{num_doors};
  auto car2 = Car{num_doors};
}

auto car_list() {
  const auto n = 7;
  auto cars = std::vector<Car>{};
  cars.reserve(n);
  for (size_t i = 0; i < n; ++i) {
    cars.push_back(Car{});
  }
}

TEST(HeapAllocations, Cars) {
  some_func();
  car_list();
}
