#include "chapter_12.h"
#ifdef SUPPORTS_COROUTINES

#include <version>

#include <gtest/gtest.h>

#include "resumable.h"

#include <functional>
#include <iostream>
#include <limits>
#include <string>

namespace {

// Uwaga: wisząca referencja do zmiennej str!
auto coroutine_ref(const std::string& str) -> Resumable { // Uwaga! Referencja
  std::cout << str;
  co_return;
}

auto coro_factory_ref() {
  auto str = std::string{"ABC"};
  auto res = coroutine_ref(str);
  return res;
}

// Poprawne: przekazywanie zmiennej typu string przez wartość
auto coroutine(std::string str) -> Resumable { // Poprawnie: przekazywanie przez wartość!
  std::cout << str;
  co_return;
}
auto coro_factory() {
  auto str = std::string{"ABC"};
  auto res = coroutine(str);
  return res;
}

// Uwaga: wisząca referencja do zmiennej str!
auto lambda_factory() {
  auto str = std::string{"ABC"};
  auto lambda = [&str]() { // Przechwytywanie zmiennej str przez referencję
    std::cout << str;
  };
  return lambda; // Ups! str w lambdzie 
} // staje się wiszącą referencją.

} // namespace

TEST(DanglingReferences, CoroutineWithStringReference) {
  auto coro = coro_factory_ref();
  // coro.resume(); // Niezdefiniowane działanie
}

TEST(DanglingReferences, CoroutineWithStringValue) {
  auto coro = coro_factory();
  coro.resume(); // Poprawnie!
}

TEST(DanglingReferences, LambdaWithStringReference) {
  auto f = lambda_factory();
  // f(); // Niezdefiniowane działanie
}

//
// Korutyny będące funkcjami składowymi
//

namespace {

struct Widget {
  auto coroutine() -> Resumable {    // Funkcja składowa
    std::cout << i++ << " "; // Dostęp do zmiennej składowej
    co_await std::suspend_always{};
    std::cout << i++ << " ";
  }
  int i{};
};

auto widget_coro_factory() { // Tworzy i zwraca korutynę
  auto w = Widget{};
  auto coro = w.coroutine();
  return coro;
} // Uwaga: tu obiekt w jest usuwany

} // namespace

TEST(DanglingReferences, WidgetMemberFunction) {
  auto w = Widget{99};
  auto coro = w.coroutine();
  coro.resume();
  coro.resume();
  // Wyświetla: 99 100
}

TEST(DanglingReferences, WidgetMemberFunctionUndefinedBehavior) {
  auto r = widget_coro_factory();
  // r.resume(); // Niezdefiniowane działanie
  // r.resume();
}

//
// Lambdy będące korutynami
//

TEST(DanglingReferences, CoroutineLambdaOK) {

  auto lambda = [](int i) -> Resumable {
    std::cout << i;
    co_return; // Tworzenie korutyny.
  };
  auto coro = lambda(42); // Wywołanie, które skutkuje utworzeniem ramki korutyny.
  coro.resume();          // Dane wyjściowe: 42
}

TEST(DanglingReferences, CoroutineLambdaUndefinedBehavior) {
  auto coro = [i = 0]() mutable -> Resumable {
    std::cout << i++;
    co_await std::suspend_always{};
    std::cout << i++;
  }(); // Natychmiastowe wywołanie lambdy
  // coro.resume(); // Niezdefiniowane działanie! Obiekt funkcyjny
  // coro.resume(); // został już usunięty.
}

#endif // SUPPORTS_COROUINES