// Kompilacja z użyciem kompilatora clang:
// -std=c++2a -Wall -stdlib=libc++ -O3 -lpthread
#include <version>
#if defined(__cpp_lib_latch)

#include <gtest/gtest.h>

#include <array>
#include <chrono>
#include <iostream>
#include <latch>
#include <thread>
#include <vector>

void prefault_stack() {
  constexpr auto stack_size =
      500u * 1024u;                       // Nie znamy wielkości stosu.
  volatile unsigned char mem[stack_size]; // Używanie modyfikatora volatile, aby uniknąć optymalizacji.
  std::fill(std::begin(mem), std::end(mem), 0);
}

void do_work() { std::cout << "Wątek wykonuje pracę\n"; }

TEST(Latches, PrefaultStack) {
  constexpr auto n_threads = 2;
  auto initialized = std::latch{n_threads};
  auto threads = std::vector<std::thread>{};
  for (auto i = 0; i < n_threads; ++i) {
    threads.emplace_back([&] {
      prefault_stack();
      initialized.arrive_and_wait(); // Lub po prostu count_down();
      do_work();
    });
  }
  initialized.wait();
  std::cout << "Zainicjowano, rozpoczynanie pracy\n";
  for (auto&& t : threads) {
    t.join();
  }
}

#endif // latch