#include <gtest/gtest.h>

// Wymaga C++20
TEST(LambdaTypes, StatelessLambdas) {
  auto x = [] {}; // Lambda bez przechwytywanych zmiennych.
  auto y = x;     // Możliwe przypisanie.
  decltype(y) z;  // Domyślna możliwość tworzenia obiektów.
  static_assert(std::is_same_v<decltype(x), decltype(y)>); // Poprawne.
  static_assert(std::is_same_v<decltype(x), decltype(z)>); // Poprawne.
}