#include <gtest/gtest.h>

template <int N, typename T> 
auto const_pow_n(const T& v) {
  auto product = T{1};
  for (int i = 0; i < N; ++i) {
    product *= v;
  }
  return product;
}

// Specjalizacja szablonu z użyciem:
// N = 2
// T = int
template <> 
auto const_pow_n<2, int>(const int& v) { 
  return v * v; 
}

TEST(IntegerAsTemplateParameter, ConstPowN) {
  // Kompilator generuje funkcję, która podnosi wartość do kwadratu
  auto x2 = const_pow_n<2>(4.0f); // Podnoszenie do kwadratu
  ASSERT_FLOAT_EQ(16.0f, x2);

  // Kompilator generuje funkcję, która podnosi wartość do sześcianu
  auto x3 = const_pow_n<3>(4.0f); // Podnoszenie do sześcianu
  ASSERT_FLOAT_EQ(64.0f, x3);
}

TEST(IntegerAsTempalteParameter, TemplateSpecialization) {

  auto x2 = const_pow_n<2>(4); // Używanie specjalizacji szablonu
  ASSERT_EQ(16, x2);

  auto x3 = const_pow_n<3>(4); // Używanie generycznego szablonu
  ASSERT_EQ(64, x3);
}
