#include <cassert>
#include <functional>
#include <gtest/gtest.h>
#include <iostream>
#include <vector>

//
// Prosty przykład użycia
TEST(StdFunction, FunctionCall) {
  // Tworzenie obiektu typu std::function bez przypisanej funkcji.
  auto func = std::function<void(int)>{};

  // Przypisywanie lambdy bez przechwytywanych zmiennych do obiektu typu std::function.
  func = [](int v) { std::cout << v; };
  func(12); // Wyświetla 12

  // Przypisywanie lambdy z przechwytywanymi zmiennymi do tego samego obiektu typu std::function.
  auto forty_two = 42;
  func = [forty_two](int v) { std::cout << (v + forty_two); };
  func(12); // Wyświetla 54
}

//
// Implementacja klasy Button z użyciem typu std::function
class Button {
public:
  Button(std::function<void(void)> click) : handler_{click} {}
  auto on_click() const { handler_(); }

private:
  std::function<void(void)> handler_{};
};

auto create_buttons() {
  auto beep = Button([counter = 0]() mutable {
    std::cout << "Bip:" << counter << "! ";
    ++counter;
  });
  auto bop = Button([] { std::cout << "Bop. "; });
  auto silent = Button([] {});

  return std::vector<Button>{beep, bop, silent};
}

TEST(StdFunction, Buttons) {
  const auto& buttons = create_buttons();
  for (const auto& b : buttons) {
    b.on_click();
  }
  buttons.front().on_click(); // Licznik został zwiększony
  // Dane wyjściowe: "Bip: 0! Bop. Bip: 1!"
}
