#include "systick.h"

#define CTRL_ENABLE		(1U<<0)
#define CTRL_CLCKSRC	(1U<<2)
#define CTRL_COUNTFLAG	(1U<<16)

/*Domyślna częstotliwość zegara MCU to 16 Mhz*/
#define ONE_MSEC_LOAD	 16000


void systick_msec_delay(uint32_t delay)
{

    /*Wczytujemy do timera liczbę cykli zegara na mikrosekundę*/
	SysTick->LOAD =  ONE_MSEC_LOAD - 1;

    /*Zerujemy rejestr bieżącej wartości SysTick*/
	SysTick->VAL = 0;

    /*Wybieramy wewnętrzne źródło zegara*/
	SysTick->CTRL = CTRL_CLCKSRC;

	/*Włączamy SysTick*/
	SysTick->CTRL |=CTRL_ENABLE;

	for(int i = 0; i < delay; i++)
	{
		while((SysTick->CTRL & CTRL_COUNTFLAG) == 0){}
	}

	/*Wyłączamy SysTick*/
	SysTick->CTRL = 0;

}
