#include "gpio.h"

#define GPIOAEN            (1U<<0)
#define GPIOCEN (1U<<2)
#define BTN_PIN (1U<<13)
#define LED_BS5            (1U<<5)  /*Ustawianie bitu, pin 5.*/
#define LED_BR5            (1U<<21) /*Zerowanie bitu, pin 5.*/



void led_init(void)
{
    /*Włączanie dostępu do zegara dla GPIOA*/
    RCC->AHB1ENR |= GPIOAEN;

    /*Ustawianie PA5 w tryb wyjściowy*/
    GPIOA->MODER |=(1U<<10);
    GPIOA->MODER &=~(1U<<11);
}
void led_on(void)
{
    /*Ustawianie PA5 w stan wysoki*/
    GPIOA->BSRR |=LED_BS5;
}
void led_off(void)
{
    /*Ustawianie PA5 w stan niski*/
    GPIOA->BSRR |=LED_BR5;

}

void button_init(void)
{
    /*Włączanie dostępu do zegara dla portu C*/
    RCC->AHB1ENR |=GPIOCEN;
    /*Ustawianie PC13 jako pinu wejściowego*/
    GPIOC->MODER &=~(1U<<26);
    GPIOC->MODER &=~(1U<<27);
}

bool get_btn_state(void)
{ /*Uwaga: BTN jest aktywny w stanie niskim */
    /*Sprawdzamy, czy przycisk jest wciśnięty */
    if(GPIOC->IDR & BTN_PIN)
    {
        return false;
    }
    else
    {
        return true;
    }
}

