#include "iwdg.h"

#define IWDG_KEY_ENABLE              0x0000CCCCU
#define IWDG_KEY_WR_ACCESS_ENABLE    0x00005555U
#define IWDG_PRESCALER_4             0x00000000U
#define IWDG_RELOAD_VAL              0xFFF

static uint8_t isIwdg_ready(void);

void iwdg_init(void)
{
    /* Włączanie IWDG przez wpisanie 0x0000 CCCC do rejestru IWDG_KR */
    IWDG->KR = IWDG_KEY_ENABLE;

    /* Włączanie dostępu do rejestrów przez wpisanie 0x0000 5555 do rejestru IWDG_KR*/
    IWDG->KR = IWDG_KEY_WR_ACCESS_ENABLE;

    /*Ustawianie preskalera IWDG*/
    IWDG->PR =  IWDG_PRESCALER_4;

    /*Ustawianie rejestr przeładowania (IWDG_RLR) na maksymalną wartość 0xFFF */
    IWDG->RLR = IWDG_RELOAD_VAL;

    /* Czekanie na aktualizację rejestrów (IWDG_SR = 0x0000 0000)*/
    while(isIwdg_ready() != 1){}

    /* Przeładowywanie wartości licznika za pomocą IWDG_KR (IWDG_KR = 0x0000 AAAA)*/
    IWDG->KR = IWDG_KEY_RELOAD;
}

static uint8_t isIwdg_ready(void)
{
 return ((READ_BIT(IWDG->SR, IWDG_SR_PVU | IWDG_SR_RVU) == 0U) ? 1UL : 0UL);
}
