#include <stdio.h>
#include <string.h>
#include "standby_mode.h"
#include "gpio_exti.h"
#include "uart.h"



/*
 * Aby przetestować projekt, najpierw nacisnij niebieski przycisk, aby przejść do trybu gotowości.
 * Pamiętaj, PA0 jest skonfigurowany jako pin wybudzania aktywny w stanie niskim.
 * W normalnym trybie podłącz przewód od PA0 do masy.
 * Aby wyzwolić zdarzenie wybudzania, odłącz przewód od masy i podłącz go do 3,3V.
 * Spowoduje to zmianę stanu logicznego, która wybudzi mikrokontroler ze stanu gotowości.
 *
 * */

uint8_t g_btn_press;
static void check_reset_source(void);


int main(void)
{

	uart_init();

	wakeup_pin_init();

	/* Sprawdzanie źródła resetu */
    check_reset_source();

	/* Inicjalizacja EXTI */
	pc13_exti_init();


	while(1)
	{

	}
}



static void check_reset_source(void)
{

	  /* Włączanie dostępu do zegara dla PWR */
	  RCC->APB1ENR |= RCC_APB1ENR_PWREN;

	  if ((PWR->CSR & PWR_CSR_SBF) == (PWR_CSR_SBF))
	  {
		  /* Zerowanie flagi gotowości */
		  PWR->CR |= PWR_CR_CSBF;

		  printf("System wznawia działanie ze stanu gotowości.....\n\r");

		  /* Czekanie na zwolnienie pinu wybudzania */
		  while(get_wakeup_pin_state() == 0){}

	  }

	  /* Sprawdzanie i zerowanie flagi wybudzenia */
	  if((PWR->CSR & PWR_CSR_WUF) == PWR_CSR_WUF )
	  {
		  PWR->CR |= PWR_CR_CWUF;
	  }
}

static void exti_callback(void)
{
	standby_wakeup_pin_setup();


}


void EXTI15_10_IRQHandler(void) {
	if((EXTI->PR & LINE13)!=0)
	{
		/* Zerowanie flagi PR */
		EXTI->PR |=LINE13;

		// Tu można coś zrobić...
		exti_callback();
	}

}
