#!/bin/bash -x

# Skrypt powłoki pozwalający na wykonanie pewnych zapytań względem bazy  
# danych pgbench oraz przykładowych zapytań bufora pokazujących
# co się dzieje wewnątrz po ich wykonaniu.

DBNAME="pgbench"

# Przeprowadzenie testu wydajności w celu umieszczenia w buforze typowych danych
#pgbench -S -c 8 -t 25000 $DBNAME

# Wyświetlenie podstawowych informacji konfiguracyjnych
psql -d $DBNAME -c "
SELECT 
  setting AS shared_buffers,
  pg_size_pretty((SELECT setting FROM pg_settings WHERE name='block_size')::int8 * setting::int8) AS size 
FROM pg_settings WHERE name='shared_buffers'
"

psql -d $DBNAME -c "
SELECT pg_size_pretty(pg_database_size(current_database()))
"


# Najlepsza dziesiątka z pg_buffercache README:
psql -d $DBNAME -c "
SELECT
  c.relname,
  count(*) AS buffers
FROM pg_class c 
  INNER JOIN pg_buffercache b
    ON b.relfilenode=c.relfilenode 
  INNER JOIN pg_database d
    ON (b.reldatabase=d.oid AND d.datname=current_database())
GROUP BY c.relname
ORDER BY 2 DESC
LIMIT 10
"

# Prosty podział względem użycia
psql -d $DBNAME -c "
SELECT 
  usagecount,count(*),isdirty
FROM pg_buffercache 
GROUP BY isdirty,usagecount 
ORDER BY isdirty,usagecount
"

# Podsumowanie zawartości bufora, procentowo
psql -d $DBNAME -c "
SELECT 
  c.relname,
  pg_size_pretty(count(*) * 8192) as buffered,
  round(100.0 * count(*) / 
    (SELECT setting FROM pg_settings WHERE name='shared_buffers')::integer,1) 
    AS buffers_percent,
  round(100.0 * count(*) * 8192 / pg_relation_size(c.oid),1) 
    AS percent_of_relation
FROM pg_class c
  INNER JOIN pg_buffercache b 
    ON b.relfilenode = c.relfilenode
  INNER JOIN pg_database d
    ON (b.reldatabase = d.oid AND d.datname = current_database())
GROUP BY c.oid,c.relname
ORDER BY 3 DESC
LIMIT 10
"

# Rozkład użycia bufora
psql -d $DBNAME -c "
SELECT
  c.relname, count(*) AS buffers,usagecount
FROM pg_class c
  INNER JOIN pg_buffercache b 
    ON b.relfilenode = c.relfilenode
  INNER JOIN pg_database d
    ON (b.reldatabase = d.oid AND d.datname = current_database())
GROUP BY c.relname,usagecount
ORDER BY c.relname,usagecount
"

