/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sdo.stockrest;

import java.io.IOException;
import java.util.logging.LogManager;

import io.helidon.microprofile.server.Server;

/**
 * Metoda Main symulująca wywoływanie głównej metody na serwerze.
 */
public final class Main {

    /**
     * Nie można utworzyć instancji.
     */
    private Main() { }

    /**
     * Główny punkt wejścia do aplikacji.
     * @param args Parametry wiersza poleceń
     * @throws Zgłasza wyjątek IOException gdy pojawi się problem z odczytaniem właściwości dziennika 
     */
    public static void main(final String[] args) throws IOException {
        setupLogging();

	int port = 8080;
	int curArg = 0;
	if (args.length > 0 && args[0].startsWith("-p")) {
	    port = Integer.parseInt(args[++curArg]);
	    curArg++;
	}

        Server server = startServer(port);

        System.out.println("Serwer gotowy");
	if (curArg < args.length && "stop".equals(args[curArg])) {
		server.stop();
		System.out.println("Zatrzymany");
	}
    }

    /**
     * Uruchomienie serwera.
     * @return Zwraca utworzoną instancję {@link Server}
     */
    static Server startServer(int port) {
        // Serwer automatycznie odczytuje konfigurację z pliku
        // microprofile-config.properties
        // i klas Application oznaczonych adnotacją @ApplicationScoped
        return Server.builder().port(port).build().start();
    }

    /**
     * Konfiguracja dziennika zgodnie z plikiem logging.properties.
     */
    private static void setupLogging() throws IOException {
        // Załadowanie konfiguracji dziennika.
        LogManager.getLogManager().readConfiguration(
                Main.class.getResourceAsStream("/logging.properties"));
    }
}
