package com.example.networkactivitysample;
/*
* 
Przykładowa aplikacja, autor Doug Sillars, program AT&T Developer Program
Ten przykładowy kod jest oparty na przykładowych aplikacjach, które można znaleźć w serwisie Stack Overflow
i na innych stronach w Internecie.
Korzystaj z niego na własne ryzyko, ani AT&T ani Doug nie ponoszą odpowiedzialności za błędy,
niezamierzone wybuchy reaktorów, czy odpalenia rakiet spowodowane użyciem tej aplikacji.
Aplikacja wymaga dostępu administracyjnego do urządzenia i bibliotek AT&T Network Attenuator.
Jeżeli chcesz z niej korzystać nie mając takiego dostępu, po prostu usuń bibliotekę i odwołania do niej.
Ta aplikacja sprawdza bieżący stan sieci, a następnie na podstawie jej parametrów technicznych określa,
czy jest to sieć „wolna”, „średnia”, czy „szybka”. W zależności od szybkości sieci aplikacja wybiera pliki
do pobrania i udostępnienia użytkownikowi.
Biblioteka Network Attenuator odczytuje stan sieci i klasyfikuje ją jako szybką, średnią lub wolną.

*/

import java.io.InputStream;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;

//import com.att.android.networkattenuatorlib.api.ARONetworkAttenuator;
//import com.att.android.networkattenuatorlib.api.AbstractNetworkAttenuator;
//import com.att.android.networkattenuatorlib.bean.NetworkConfig;

public class MainActivity extends Activity {
	//AbstractNetworkAttenuator an;
	BroadcastReceiver changeReceiver;
	TextView Networkstate;
	Button button;
	CheckBox FNAcheck;
	int signalStrengthValue;
	int contentlength;
	ImageView BackgroundImage;
	String urlbig = "http://i661.photobucket.com/albums/uu340/dougtest/bridge_525_zps6dd074cb.jpg";
	String urlmed = "http://i661.photobucket.com/albums/uu340/dougtest/bridge_525_50_zps30a24b7d.jpg";
	String urlsmall = "http://i661.photobucket.com/albums/uu340/dougtest/bridge_525_10_zpsf0678e67.jpg";
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.activity_main);
		Networkstate = (TextView) findViewById(R.id.NetworkState);
		 button = (Button) findViewById(R.id.button1);
		 FNAcheck = (CheckBox) findViewById(R.id.FNAcheck);
		 BackgroundImage =(ImageView) findViewById(R.id.bgimage);
	//	if (savedInstanceState == null) {
		//	getFragmentManager().beginTransaction()
			//		.add(R.id.container, new PlaceholderFragment()).commit();
		//}
		
		button.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				BackgroundImage.setImageDrawable(null);
				Networkstate.setText("");
				System.out.println("button clicked");
				
				
				try {
			//		an = new ARONetworkAttenuator(getApplicationContext());
			//		NetworkConfig nc = an.getNetworkConfig();
					int downlinkspeed = 0;
			//		downlinkspeed = nc.getDownlinkSpeed();

					// Odczytanie danych sieci
					TelephonyManager teleMan = (TelephonyManager)getSystemService(Context.TELEPHONY_SERVICE);
				//	PhoneStateListener psl = new PhoneStateListener();  
					//teleMan.listen(psl,PhoneStateListener.LISTEN_SIGNAL_STRENGTHS);



					// Odczytanie nazwy operatora
					String operatorname =teleMan.getNetworkOperatorName();
					// Sprawdzenie roamingu
					boolean roaming = teleMan.isNetworkRoaming();

					// Opis technologii sieci
					String netType = "";

					// Założenie, że sieć jest szybka
					String NetworkSpeed = "fast";
					
					if (downlinkspeed == 0) {
						// Biblioteka AT&T Network Attenuator nie jest wykorzystywana,
						// ponieważ zmienna downlinkspeed miałaby wtedy wartość większą niż 0

						// Odczytanie typu sieci z urządzenia
						int networkType = teleMan.getNetworkType();
						// Konwersja liczby całkowitej na ciąg znaków
						
						switch (networkType)
						{
						case 7:
						    netType = "1xRTT";
						    NetworkSpeed = "wolna";
						    break;      
						case 4:
							netType = "CDMA";
						    break;      
						case 2:
							netType = "EDGE";
							NetworkSpeed = "wolna";
						    break;  
						case 14:
							netType = "eHRPD";
							NetworkSpeed = "wolna";
						    break;      
						case 5:
							netType = "EVDO rev. 0";
							NetworkSpeed = "wolna";
						    break;  
						case 6:
							netType = "EVDO rev. A";
							NetworkSpeed = "średnia";
						    break;  
						case 12:
							netType = "EVDO rev. B";
							NetworkSpeed = "średnia";
						    break;  
						case 1:
							netType = "GPRS";
							NetworkSpeed = "wolna";
						    break;      
						case 8:
						    netType = "HSDPA";
						    NetworkSpeed = "średnia";
						    break;      
						case 10:
							netType = "HSPA";
							NetworkSpeed = "szybka";
						    break;          
						case 15:
							netType = "HSPA+";
							NetworkSpeed = "szybka";
						    break;          
						case 9:
							netType = "HSUPA";
							NetworkSpeed = "szybka";
						    break;          
						case 11:
							netType = "iDen";
							NetworkSpeed = "szybka";
						    break;
						case 13:
							netType = "LTE";
							NetworkSpeed = "szybka";
						    break;
						case 3:
							netType = "UMTS";
							NetworkSpeed = "średnia";
						    break;          
						case 0:
							netType = "Unknown";
							NetworkSpeed = "średnia";
						    break;

						}

						Networkstate.setText("Bieżące ustawienia: \nAktywna sieć: " + netType+"\nSugerowana szybkość: " +NetworkSpeed+ "\nOperator: "+ operatorname +"\nRoaming: " +roaming);
					} else {

						// Szybkość sieci określona za pomocą biblioteki Attenuator
					
						
						switch(downlinkspeed){
						case 80:
							netType = "GPRS";
							NetworkSpeed = "wolna";
							break;
						case 236:
							netType = "EDGE";
							NetworkSpeed = "wolna";
							break;
						case 1920:
							netType = "UMTS";
							NetworkSpeed = "średnia";
							break;
						case 14400:
							netType = "HSPA+";
							NetworkSpeed = "szybka";
							break;
						case 22000:
							netType = "LTE";
							NetworkSpeed = "szybka";
							break;
					    default:
							// Jeżeli zmienna downlinkspeed zawiera inną wartość, oznacza to nietypowe ustawienia sieci
					    	netType = "Inna";
					    	break;	
						}
						
					Networkstate.setText("Bieżące ustawienia:\nNetwork Attenuator " + netType + "\nSugerowana szybkość: " +NetworkSpeed+"\nOperator: "+ operatorname +"\nRoaming: " +roaming);//"\n" + nc.toString()+
					}
					// Tu wykorzystywane są określone wcześniej ustawienia,
					// ale tylko wtedy, gdy opcja FNA jest zaznaczona
					if (FNAcheck.isChecked() ) {
							switch(NetworkSpeed){
							case "szybka":
								new ImageDownloader().execute(urlbig);
								break;
							case "średnia":
								new ImageDownloader().execute(urlmed);
								break;
							case "wolna":
								new ImageDownloader().execute(urlsmall);
								break;
							}
							Networkstate.setTextColor(Color.WHITE);
					}
					else{
						// Nie chcemy stosować ustawień FNA, więc używamy dużego obrazu
						new ImageDownloader().execute(urlbig);
						Networkstate.setTextColor(Color.RED);
						Networkstate.append("Ustawienia FNA pominięte");
					}
					
				} catch (Exception e) {
					// Automatycznie utworzony blok kodu
					e.printStackTrace();
				}
			}});
			

		
	}
	
	
	
	
	
	 private class ImageDownloader extends AsyncTask<String, Void,Bitmap>  {
		 TextView downloadtimes; 
         Long responsetime;
         Long imagetime;
         Long contentlength;
         Double Throughput;

	        @Override
	        protected Bitmap doInBackground(String... param) {
	            // Automatycznie utworzony szablon metody
	            return downloadBitmap(param[0]);
	        }
	 
	        @Override
	        protected void onPreExecute() {
	            Log.i("Przykład asynchr.", "Wywołanie onPreExecute");
	            downloadtimes =  (TextView) findViewById(R.id.Downloadtimes);
	         
	       //     simpleWaitDialog = ProgressDialog.show(ImageDownladerActivity.this,
	        //            "Wait", "Downloading Image");
	 
	        }
	 
	        @Override
	        protected void onPostExecute(Bitmap result) {
	            Log.i("Przykład asynchr.", "Wywołanie onPostExecute");
	            BackgroundImage.setImageBitmap(result);
                downloadtimes.append("\nKod 200: " + responsetime +"\nPobieranie: " + imagetime + "\nwielkość: "+ contentlength +"\nprzepływność: " +Throughput);
                downloadtimes.setTextColor(Color.RED);
	            
	       //     simpleWaitDialog.dismiss();
	 
	        }
	 
	        private Bitmap downloadBitmap(String url) {
	        	Long start = System.currentTimeMillis();
				  // Zainicjowanie domyślnego obiektu klienckiego HTTP
	            final DefaultHttpClient client = new DefaultHttpClient();

				  // Przygotowanie zapytania HTTP
	            final HttpGet getRequest = new HttpGet(url);
	            try {
	 
	                HttpResponse response = client.execute(getRequest);

						// Sprawdzenie kodu 200 OK oznaczającego pomyślny wynik
	                final int statusCode = response.getStatusLine().getStatusCode();
	                Long gotresponse = System.currentTimeMillis();
	                if (statusCode != HttpStatus.SC_OK) {
	                    return null;
	                }
	            
	 
	                final HttpEntity entity = response.getEntity();
	                contentlength = entity.getContentLength();
	                if (entity != null) {
	                    InputStream inputStream = null;
	                    try {
								  // Odczytanie treści ze strumienia
	                        inputStream = entity.getContent();

								  // Konwersja danych ze strumienia na format graficzny zrozumiały dla systemu Android
	                        final Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
	                        Long gotimage = System.currentTimeMillis();
	                        responsetime  = gotresponse - start;
	                        imagetime     = gotimage-start;
	                        Throughput    = ((double)contentlength/1024)/((double)imagetime/1000);  //Kbit/s
	                        return bitmap;
	                    } finally {
	                        if (inputStream != null) {
	                            inputStream.close();
	                        }
	                        entity.consumeContent();
	                    }
	                }
	            } catch (Exception e) {
						// Tu można wpisać dokładniejszy komunikat o wyjątku IOException
	                getRequest.abort();
						Log.e("pobieranie obrazów", "Coś poszło źle podczas" +
								" pobierania obrazu z adresu " + url + e.toString());
	            } 
	 
	            return null;
	        }

			
	    }	
	
	
	

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Utworzenie menu i dodanie elementów do paska akcji jeżeli jest widoczny
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	@Override
    protected void onResume() {
        super.onResume();
        if (changeReceiver == null){
        	changeReceiver = new BroadcastReceiver(){
        		
        		@Override
        		public void onReceive(Context context, Intent intent) {
        			System.out.println("Konfiguracja sieci zmieniona");
       // 			System.out.println("New settings: " + an.getNetworkConfig());
        		}
        		
        	};
        }
        
//		registerReceiver(changeReceiver, 
  //       new IntentFilter(AbstractNetworkAttenuator.NETWORK_CONFIG_CHANGED_INTENT));
    }
	
	@Override
	protected void onDestroy(){
		super.onDestroy();
		if (changeReceiver != null){
			unregisterReceiver(changeReceiver);
			changeReceiver = null;
		}
	}


}

