package com.example.bigasslayout.bigasslayout;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

/**
 * Utworzono 22.12.2014.
 */


public class GoatList extends ArrayAdapter<String> {
    private final Activity context;
    private final String xmlSpeed;
    private boolean fibonacciBool;
    private final String[] goatNames;

    private final boolean[] goatTrue;
    private final int[] goatPix;


    private final boolean lotsOfObjects;

    View rowView;
    TextView rowTxt;
    ImageView rowImg;
    CheckBox rowCheck;
    int bignumber;
    int fibValue;



    boolean checked;
    CheckBox checkedBox;

    public GoatList (Activity context, String xmlspeed, Boolean fibonacciBool, String [] goatnames, int[] goatPix, boolean[] goatTrue, boolean lotsOfObjects){
        super(context, R.layout.goatrow, goatnames);
        this.context = context;
        this.xmlSpeed = xmlspeed;
        this.fibonacciBool = fibonacciBool;
        this.goatNames = goatnames;
        this.goatPix = goatPix;
        this.goatTrue = goatTrue;
        this.lotsOfObjects = lotsOfObjects;



    }
    @Override
        public View getView(int position, View view, ViewGroup parent) {
        LayoutInflater inflater = context.getLayoutInflater();


        if (xmlSpeed.matches(context.getResources().getString(R.string.slowestXml))) {
            // Powolny układ goatrow
            rowView= inflater.inflate(R.layout.goatrow, null, true);
        } else if (xmlSpeed == context.getResources().getString(R.string.overdrawXml)) {
             // Zastosowanie widoku, z którego usunięto najwięcej nakładających się układów
             rowView = inflater.inflate(R.layout.nooverdrawgoatrow, null, true);
        } else if (xmlSpeed == context.getResources().getString(R.string.removeLLoverdrawXml)) {
            // Zastosowanie widoku, z którego usunięto najwięcej nakładających się układów
            rowView = inflater.inflate(R.layout.nooverdrawgoatrow, null, true);
        } else if (xmlSpeed == context.getResources().getString(R.string.RLfastXml)) {
            // Zastosowanie widoku, z którego usunięto najwięcej nakładających się układów
            // Usunięta jest również jedna warstwa po zastosowaniu RelativeLayout
            rowView = inflater.inflate(R.layout.rlfastestgoatrow, null, true);
        } else // Najszybszy układ
        { rowView = inflater.inflate(R.layout.fastestgoatrow, null, true);
        }



        // Dodanie kolejnych obiektów – domyślnie wyłączone
        if (lotsOfObjects == false) {
            // Będą stosowane widoki zainicjowane na początku kodu
            rowTxt = (TextView) rowView.findViewById(R.id.textView);
            rowImg = (ImageView) rowView.findViewById(R.id.imageView);
            rowCheck = (CheckBox) rowView.findViewById(R.id.checkBox);

            if (fibonacciBool == true) {
                // Zwłoka – odczytanie pozycji ciągu, dodanie 4, przemnożenie przez inną (dużą) liczbę
                // Rekurencyjne wyszukiwanie elementu ciągu (powolna operacja)
                if (position ==5){
                    bignumber  = (position+8)*3;// Spowodowanie pomijania ramek podczas przewijania ekranu
                }else if (position == 10) {
                    bignumber  = (position+3)*3;// Wprowadzenie zwłoki podczas przewijania ekranu
                }else{
                    bignumber = (position+4)*2;
                }
                fibValue = fibonacci.fib(bignumber);
                // Stracony czas!
                rowTxt.setText(goatNames[position] + "\nOpóźnienie Fibonacci #: " +fibValue);
            }
            else {// Nieznaczne spowolnienie wywołanie ciągiem Fibonacciego
                rowTxt.setText(goatNames[position]);
            }
           rowImg.setImageResource((goatPix[position]));
           rowCheck.setChecked(goatTrue[position]);
            rowCheck.setOnClickListener( new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                     checkedBox = (CheckBox) v;

                    if (checkedBox.isChecked() ==false){
                        // Opcja była zaznaczona i użytkownik usunął zaznaczenie
                        // To jest koza
                        checkedBox.setChecked(true);
                        Toast.makeText(context, "Dobrze! \nTo jest koza", Toast.LENGTH_SHORT).show();
                    }
                    else{
                        // Opcja nie była zaznaczona i użytkownik ją zaznaczył
                        // To nie jest koza
                        checkedBox.setChecked(false);
                        Toast.makeText(context, "Spróbuj jeszcz raz. \nTo nie jest koza", Toast.LENGTH_SHORT).show();
                    }


                }
            });





        }
        else{ //lotsOfObjects ma wartość true
            // W każdej iteracji będzie tworzony nowy widok
            TextView rowTxtWaste = (TextView) rowView.findViewById(R.id.textView);
            ImageView rowImgWaste = (ImageView) rowView.findViewById(R.id.imageView);
            CheckBox rowCheckWaste = (CheckBox) rowView.findViewById(R.id.checkBox);
            // Podczas wyświetlania treści tworzonych jest mnóstwo obiektów
            if (fibonacciBool == true) {
                // Zwłoka – odczytanie pozycji ciągu, dodanie 4, przemnożenie przez inną (dużą) liczbę
                // Rekurencyjne wyszukiwanie elementu ciągu (powolna operacja)
                int bignumberWaste;
                if (position ==5){
                    bignumberWaste  = (position+8)*3;// Spowodowanie pomijania ramek podczas przewijania ekranu
                //}else if (position == 10) {
                  //  bignumberWaste  = (position+3)*3;// Wprowadzenie zwłoki podczas przewijania ekranu
                }else{
                    bignumberWaste = (position+4)*2;
                }
                int fibValueWaste;
                fibValueWaste = fibonacci.fib(bignumberWaste);
                // Stracony czas!
                rowTxtWaste.setText(goatNames[position] + "\nDelay Fibonacci #: " +fibValueWaste);
            }
            else {// Nieznaczne spowolnienie wywołanie ciągiem Fibonacciego
                rowTxtWaste.setText(goatNames[position]);
            }

            rowImgWaste.setImageResource((goatPix[position]));
            rowCheckWaste.setChecked(goatTrue[position]);

            rowCheckWaste.setOnClickListener( new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    // Nowa zmienna dla pola wyboru
                    CheckBox checkedBoxWaste = (CheckBox) v;

                    if (checkedBoxWaste.isChecked() ==false){
                        // Opcja była zaznaczona i użytkownik usunął zaznaczenie
                        // To jest koza
                        checkedBoxWaste.setChecked(true);
                        Toast.makeText(context, "Dobrze! \nTo jest koza", Toast.LENGTH_SHORT).show();
                    }
                    else{
                        // Opcja nie była zaznaczona i użytkownik ją zaznaczył
                        // To nie jest koza
                        checkedBoxWaste.setChecked(false);
                        Toast.makeText(context, "Spróbuj jeszcz raz. \nTo nie jest koza", Toast.LENGTH_SHORT).show();
                    }

                }
            });
        }



        return rowView;
    }

}

