<?php 
/*
Plugin Name: Jednorazowe zadanie cron
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Utworzenie jednorazowego zadania cron.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Utworzenie menu wtyczki.
add_action( 'admin_menu', 'boj_cron_single_menu' );

function boj_cron_single_menu() {

	// Utworzenie przykładowej strony ustawień.
    add_options_page( 'Przykład ustawień Cron', 'Ustawienia Cron', 'manage_options', 'boj-single-cron', 'boj_cron_single_settings' );
	
}

// Utworzenie własnego zaczepu wywoływanego przez zadanie harmonogramu.
add_action( 'boj_single_cron_hook', 'boj_cron_single_email_reminder' );

function boj_cron_single_email_reminder() {

	// Wysłanie wiadomości e-mail.
	wp_mail( 'ty@przyklad.pl', 'Przypomnienie', 'Masz spotkanie!' );

}

function boj_cron_single_settings() {

	// Upewnienie się, że zadanie nie zostało wcześniej umieszczone w harmonogramie.
	if ( !wp_next_scheduled( 'boj_single_cron_hook' ) ) {
	
		// Określenie, że zadanie będzie wykonane w ciągu godziny.
		wp_schedule_single_event( time()+3600, 'boj_single_cron_hook' );
		
	}

}
?>
