<?php
/*
Plugin Name: Natychmiastowe usunięcie komentarza
Plugin URI: http://przyklad.pl/
Description: Dodaje odnośnik pozwalający na natychmiastowe usunięcie komentarza.
Author: Ozh
Version: 1.0
Author URI: http://wrox.com/
*/

// Dodanie skryptu na stronie zawierającej pojedynczy wpis bloga oraz na stronach z komentarzami, ale tylko wtedy, gdy użytkownik na uprawnienia do edycji.
add_action( 'template_redirect', 'boj_idc_addjs_ifcomments' );
function boj_idc_addjs_ifcomments() {
    if( is_single() && current_user_can( 'moderate_comments' ) ) {
        global $post;
        if( $post->comment_count ) {
            $path = plugin_dir_url( __FILE__ );

            wp_enqueue_script( 'boj_idc', $path.'js/script.js' );
            $protocol = isset( $_SERVER["HTTPS"]) ? 'https://' : 'http://';
            $params = array(
              'ajaxurl' => admin_url( 'admin-ajax.php', $protocol )
            );
            wp_localize_script( 'boj_idc', 'boj_idc', $params );
        }
    }
}

// Dodanie odnośnika administracyjengo pod każdym komentarzem.
add_filter( 'comment_text', 'boj_idc_add_link' );
function boj_idc_add_link( $text ) {
    // Pobranie identyfikatora bieżącego komentarza.
    global $comment;
    $comment_id = $comment->comment_ID;

    // Pobranie odnośnika do strony administracyjnej w celu usunięcia komentarza oraz dodanie unikalnej wartości.
    $link = admin_url( 'comment.php?action=trash&c='.$comment_id );
    $link = wp_nonce_url( $link, 'boj_idc-delete-'.$comment_id );
    $link = "<a href='$link' class='boj_idc_link'>Usuń komentarz</a>";
    
    // Dodanie odnośnika do tekstu komentarza.
    return $text."<p>[admin: $link]</p>";
}

// Obsługa żądania Ajax.
add_action( 'wp_ajax_boj_idc_ajax_delete', 'boj_idc_ajax_delete' );
function boj_idc_ajax_delete() {
    $cid = absint( $_POST['cid'] );
    
    $response = new WP_Ajax_Response;

    if(
        current_user_can( 'moderate_comments' ) &&
        check_ajax_referer( 'boj_idc-delete-'.$cid, 'nonce', false ) &&
        wp_delete_comment( $cid  )
    ) {
        // Żądanie zakończyło się powodzeniem.
        $response->add( array(
            'data' => 'success',
            'supplemental' => array(
                'cid'     => $cid,
                'message' => 'ten komentarz został usunięty'
            ),
        ) );
    } else {
        // Żądanie zakończyło się niepowodzeniem.
        $response->add( array(
            'data' => 'error',
            'supplemental' => array(
                'cid'     => $cid,
                'message' => 'wystąpił błąd'
            ),
        ) );
    }

    $response->send();
    
    exit();
}
?>
