<?php

add_action( 'init', 'boj_music_album_register_shortcodes' );

function boj_music_album_register_shortcodes() {

    /* Rejestracja skrótu [music_albums]. */
    add_shortcode( 'music_albums', 'boj_music_albums_shortcode' );
}

function boj_music_albums_shortcode() {

    /* Pobranie z bazy danych informacji o albumach. */
    $loop = new WP_Query(
        array(
            'post_type' => 'music_album',
            'orderby' => 'title',
            'order' => 'ASC',
            'posts_per_page' => -1,
        )
    );

    /* Sprawdzenie, czy zostały pobrane dane jakiegokolwiek albumu. */
    if ( $loop->have_posts() ) {

        /* Początek nieuporządkowanej listy. */
        $output = '<ul class="music-collection">';

        /* Przeprowadzenie iteracji przez albumy (pętla). */
        while ( $loop->have_posts() ) {

            $loop->the_post();

            /* Wyświetlenie tytułu albumu. */
            $output .= the_title(
                '<li><a href="' . get_permalink() . '">',
                '</a></li>',
                false
            );

            /* Wstawienie pustego wiersza. */
            $output .= '<br />';

            /* Wyświetlenie artysty albumu. */
            $output .= get_the_term_list( get_the_ID(), 'album_artist', 
                'Artysta: ', ', ', ' ' );

            /* Wyświetlenie gatunku albumu. */
            $output .= get_the_term_list( get_the_ID(), 'album_genre',
                'Gatunek: ', ', ', ' ' );

        }

        /* Koniec nieuporządkowanej listy. */
        $output .= '</ul>';
    }

    /* Jeżeli nie znaleziono żadnych albumów. */
    else {
        $output = '<p>Nie opublikowano żadnych albumów.';
    }

    /* Zwrot listy albumów muzycznych. */
    return $output;
}

?>
