<?php
/*
Plugin Name: Ulubiony wpis bloga użytkownika
Plugin URI: http://przyklad.pl
Description: Wtyczka pozwala użytkownikowi na wybór ulubionego wpisu bloga na jego witrynie.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Dodanie formularza na stronie profilu użytkownika w obszarze administracyjnym. */
add_action( 'show_user_profile', 'boj_user_favorite_post_form' );
add_action( 'edit_user_profile', 'boj_user_favorite_post_form' );

/* Funkcja wyświetlająca dodatkowy formularz na stronie profilu użytkownika. */
function boj_user_favorite_post_form( $user ) {

    /* Pobranie aktualnego ulubionego wpisu bloga użytkownika. */
    $favorite_post = get_user_meta( $user->ID, 'favorite_post', true );

    /* Pobranie listy wszystkich wpisów bloga. */
    $posts = get_posts( array( 'numberposts' => -1 ) );
    ?>

    <h3>Ulubione</h3>

    <table class="form-table">

        <tr>
            <th><label for="favorite_post">Ulubiony wpis bloga</label></th>

            <td>
                <select name="favorite_post" id="favorite_post">
                    <option value=""></option>

                <?php foreach ( $posts as $post ) { ?>
                    <option value="<?php echo esc_attr( $post->ID ); ?>" 
                    <?php selected( $favorite_post, $post->ID ); ?>>
                        <?php echo esc_html( $post->post_title ); ?>
                    </option>
                <?php } ?>

                </select>
                <br />
                <span class="description">Wybierz ulubiony wpis bloga.</span>
            </td>
        </tr>

    </table>
<?php }

/* Zarejestrowanie w zaczepie funkcji uaktualniającej metadane użytkownika. */
add_action( 'personal_options_update', 'boj_user_favorite_post_update' );
add_action( 'edit_user_profile_update', 'boj_user_favorite_post_update' );

/* Funkcja uaktualniająca informacje o ulubionym wpisie bloga użytkownika. */
function boj_user_favorite_post_update( $user_id ) {

    /* Sprawdzenie, czy bieżący użytkownik ma uprawnienia do edycji informacji. */
    if ( !current_user_can( 'edit_user', $user_id ) )
        return false;

    /* Ponieważ to identyfikator wpisu bloga, to akceptowane są tylko cyfry od 0 do 9. */
    $favorite_post = preg_replace( "/[^0-9]/", '', $_POST['favorite_post'] );

    /* Uaktualnienie informacji o ulubionym wpisie bloga użytkownika. */
    update_user_meta( $user_id, 'favorite_post', $favorite_post );
}

?>
