<?php
/*
Plugin Name: Wymuszenie zmiany kolorów obszaru administracyjnego
Plugin URI: http://przyklad.pl
Description: Wtyczka wymusza zmianę schematu kolorów używanego w obszarze administracyjnym.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/
/* Zmiana kolorów dotyczy jedynie obszaru administracyjnego. */
add_action( 'admin_init', 'boj_force_admin_color' );
/* Wymusza na aktualnie zalogowanym użytkowniku zmiany schematu kolorów w obszarze administracyjnym. */
function boj_force_admin_color() {
    /* Pobranie obiektu aktualnego użytkownika. */
    $user = wp_get_current_user();
    /* Jeżeli zmienna $user nie jest pusta, wówczas można kontynuować działanie. */
    if ( !empty( $user ) ) {
        /* Pobranie schematu kolorów używanych w obszarze administracyjnym. */
        $admin_color = get_user_meta( $user->ID, 'admin_color', true );
        /* Jeżeli schemat koloró to nie 'fresh', wówczas należy go zmienić.. */
        if ( $admin_color !== 'fresh' ) {
            /* Ustawienie danych użytkownika. */
            $userdata = array(
                'ID' => $user->ID,
                'admin_color' => 'fresh'
            );
            /* Uaktualnienie użytkownika. */
            wp_update_user( $userdata );
        }
    }
}
?> 

