<?php
/*
Plugin Name: Nieużywane tagi
Plugin URI: http://przyklad.pl/
Description: Wyszukuje nieużywane tagi i pozwala na ich usunięcie bądź zmianę nazwy.
Author: WROX
Author URI: http://wrox.com
*/

// Dodanie w menu Post elementu pozwalającego na przejście do strony opcji.
add_action('admin_menu', 'boj_utags_add_page');
function boj_utags_add_page() {
    add_posts_page( 'Nieużywane tagi', 'Nieużywane tagi', 'manage_options',
        'boj_utags', 'boj_utags_option_page' );
}

// Przechwycenie każdego parametru boj_action w ciągu tekstowym zapytania.
add_action( 'admin_init', 'boj_utags_do_action' );

// Przejście do żądanego parametru boj_action, o ile jest taka możliwość.
function boj_utags_do_action() {
    if( !isset( $_REQUEST['boj_action'] ) )
        return;

    if( !current_user_can( 'manage_options' ) )
        wp_die( 'Niewystarczające uprawnienia!' );
        
    $id     = $_REQUEST['id'];
    $action = $_REQUEST['boj_action'];
    
    if( $action == 'done' ) {
        add_action( 'admin_notices', 'boj_utags_message' );
        return;
    }
    
    check_admin_referer( 'boj_utags-'.$action.'_tag'.$id );
    
    switch( $action ) {
        case 'rename':
            $newtag = array( 'name' => $_POST['name'], 'slug' => $_POST['name'] );
            wp_update_term( $id, 'post_tag', $newtag );
            break;
        case 'delete':
            wp_delete_term( $id, 'post_tag' );
            break;
    }

    wp_redirect( add_query_arg( array( 'boj_action' => 'done' ) ) );

}

// Komunikat dla administratora.
function boj_utags_message() {
    echo "<div class='updated'><p>Operacja została wykonana</p></div>";
}

// Wyświetlenie strony zarządzania tagami.
function boj_utags_option_page() {
    ?>
    <div class="wrap">
        <?php screen_icon(); ?>
        <h2>Nieużywane tagi</h2>
            
        <?php
        
        if( $tags = boj_utags_find_orphans() ):
        
        echo '<p>W tej chwili masz '.count( $tags ). ' nieużywanych tagów:</p>';
        echo '<ol>';
        
        foreach( $tags as $tag ) {
            $id   = $tag->term_id;
            $name = esc_attr( $tag->name );

            $delete_url= add_query_arg( array('boj_action'=>'delete','id'=>$id) );
            $nonced_url= wp_nonce_url( $delete_url, 'boj_utags-delete_tag'.$id );
            ?>
            <li>
            <form action="" method="post">
            <?php wp_nonce_field( 'boj_utags-rename_tag'.$id ); ?>
            <input type="hidden" name="boj_action" value="rename" />
            <input type="hidden" name="id" value="<?php echo $id; ?>" />
            <input type="text" name="name" value="<?php echo $name; ?>" />
            <input type="submit" value="Zmień nazwę" /> lub
            <a href="<?php echo $nonced_url; ?>">usuń</a> ten tag
            </form>
            </li>
            
        <?php }
        
        else: ?>
        <p>Nie znaleziono nieużywanych tagów.</p>
        
        <?php endif; ?>
        
        </ol>
    </div>
    <?php
}

// Wyszukanie nieużywanych tagów i ich zwrot w tablicy.
function boj_utags_find_orphans() {
    global $wpdb;
    
    $sql = "SELECT terms.term_id, terms.name FROM {$wpdb->terms} terms
            INNER JOIN {$wpdb->term_taxonomy} taxo
            ON terms.term_id=taxo.term_id
            WHERE taxo.taxonomy = 'post_tag'
            AND taxo.count=0";
            
    return $wpdb->get_results( $sql );
}
