<?php
/*
Plugin Name: Widget wyświetla ostatnie wpisy bloga sieci Multisite
Plugin URI:  http://przyklad.pl/
Description: Pobiera listę ostatnich wpisów bloga opublikowanych na witrynach sieci Multisite.
Author: Brad Williams
Version: 1.0
Author URI: http://wrox.com
*/

// Zaczep akcji widgets_init będzie użyty do wykonania własnej funkcji.
add_action( 'widgets_init', 'boj_multisite_register_widget' );

// Rejestracja naszego widgetu.
function boj_multisite_register_widget() {
	register_widget( 'boj_multisite_widget' );
}

// Klasa boj_multisite_widget.
class boj_multisite_widget extends WP_Widget {

	// Przetworzenie nowego widgetu.
	function boj_multisite_widget() {
	
		$widget_ops = array( 'classname' => 'boj_multisite_widget', 'description' => 'Wyświetla najnowsze wpisy bloga opublikowane na witrynach sieci Multisite.' );
		$this->WP_Widget( 'boj_multisite_widget_posts', 'Ostatnie wpisy bloga sieci Multisite', $widget_ops );
		
	}
 
 	// Zbudowanie formularza ustawień widgetu.
	function form( $instance ) {
		global $wpdb;
		
		$defaults = array( 'title' => 'Ostatnie wpisy bloga', 'disp_number' => '5' );
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title = $instance['title'];
		$siteid = $instance['siteid'];
		$disp_number = $instance['disp_number'];

		// Pole tekstowe zawierające tytuł widgetu.
        echo '<p>Tytuł: <input class="widefat" name="' .$this->get_field_name( 'title' ). '" type="text" value="' .esc_attr( $title ). '" /></p>';
		
		// Pobranie listy wszystkich identyfikatorów blogów dostępnych publicznie w danej sieci Multisite.
		$sql = "SELECT blog_id FROM $wpdb->blogs 
			WHERE public = '1' AND archived = '0' AND mature = '0' 
			AND spam = '0' AND deleted = '0' ";
		$blogs = $wpdb->get_col( $wpdb->prepare( $sql ) );
		
		if ( is_array( $blogs ) ) {
		
			echo '<p>';
			echo 'Witryna, z której mają być pobierane ostatnie wpisy bloga:';
			echo '<select name="' .$this->get_field_name('siteid') .'" class="widefat" >';
			
			// Iteracja przez wszystkie identyfikatory blogów.
			foreach ($blogs as $blog) {
	
				// Wyświetlenie każdej witryny jako opcji.
				echo '<option value="' .$blog. '" ' .selected( $blog, $siteid ). '>' .get_blog_details( $blog )->blogname. '</option>';
				
			}
			
			echo '</select>';
			echo '</p>';
		}

		// Liczba wpisów bloga, które mają być wyświetlone.
		echo '<p>Liczba wpisów bloga do wyświetlenia: <input class="widefat" name="' .$this->get_field_name( 'disp_number' ). '" type="text" value="' .esc_attr( $disp_number ). '" /></p>';
	}
 
  	// Zapisanie ustawień widgetu.
	function update( $new_instance, $old_instance ) {
	
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['siteid'] = absint( $new_instance['siteid'] );
		$instance['disp_number'] = absint( $new_instance['disp_number'] );
 
		return $instance;
	}
 
 	// Wyświetlenie widgetu.
	function widget( $args, $instance ) {
		extract( $args );
 
		echo $before_widget;
		
		// Wczytanie opcji widgetu.
		$title = apply_filters( 'widget_title', $instance['title'] );
		$siteid = empty( $instance['siteid'] ) ? 1 : $instance['siteid'];
 		$disp_number = empty( $instance['disp_number'] ) ? 5 : $instance['disp_number'];
 
 		// Wyświetlenie tytułu widgetu.
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; };
			
		echo '<ul>';
		
		// Przejście na wskazaną witrynę.
		switch_to_blog( absint( $siteid ) );

		// Utworzenie własnej pętli.
		$recentPosts = new WP_Query();
		$recentPosts->query( 'posts_per_page=' .absint( $disp_number ) );
		
		// Uruchomienie własnej pętli.
		while ( $recentPosts->have_posts() ) : $recentPosts->the_post();
		
			// Wyświetlenie ostatnio opublikowanego wpisu bloga wraz z odnośnikiem.
			echo '<li><a href="' .get_permalink(). '">' .get_the_title() .'</a></li>';
			
		endwhile;
		
		// Przywrócenie aktualnie odwiedzanej witryny.
		restore_current_blog();

		echo '</ul>';
		echo $after_widget;

	}

}
?>
