<?php 
/*
Plugin Name: Automatyczne dodawanie użytkownika do witryny sieci Multsite
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka automatycznie dodaje użytkownika do każdej odwiedzanej przez niego witryny.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'init', 'boj_multisite_add_user_to_site' );

function boj_multisite_add_user_to_site() {

	// Przed przejściem dalej trzeba sprawdzić, czy użytkownik jest zalogowany.
	if( !is_user_logged_in() )
		return false;
	
	// Wczytanie identyfikatora bieżącego bloga oraz danych użytkownika.
	global $current_user,$blog_id;

	// Sprawdzenie, czy użytkownik nie jest członkiem tej witryny.	 
	if( !is_blog_user() ) {
		
		// Dodanie użytkownika do witryny jako Subskrybenta.
		add_user_to_blog( $blog_id, $current_user->ID, 'subscriber' );
		
	}
	 
}

?>
