<?php
/*
Plugin Name: Struktura odnośników bezpośrednich dla produktów
Plugin URI: http://przyklad.pl/
Description: Wtyczka tworzy całą strukturę odnośników bezpośrednich.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com
*/

// Dodanie struktury odnośników bezpośrednich oraz wyczyszczenie reguł przepisywania adresów podczas aktywacji wtyczki.
register_activation_hook( __FILE__, 'boj_products_activate' );
function boj_products_activate() {
    boj_products_rewrite();
    flush_rewrite_rules();
}

// Wyczyszczenie reguł przepisywania adresów podczas dezaktywacji wtyczki.
register_deactivation_hook( __FILE__, 'boj_products_deactivate' );
function boj_products_deactivate() {
    flush_rewrite_rules();
}

// Utworzenie nowego znacznika %produkt% i obsługa adresów URL /sklep/%produkt%.
add_action('init', 'boj_products_rewrite');
function boj_products_rewrite() {
    add_rewrite_tag( '%produkt%', '([^/]+)' );
    add_permastruct( 'produkt', 'sklep' . '/%produkt%' );
}

// Jeżeli zmienna ciągu tekstowego zapytania ma wartość, wówczas wyświetlamy produkty sklepu.
add_action( 'template_redirect', 'boj_products_display' );
function boj_products_display() {
    if ( $product = get_query_var( 'produkt' ) ) {
        // include( 'display_product.php' );
        echo "wyszukiwanie produktu $product ?";
        exit;
    }
}
?>
