<?php
/*
Plugin Name: Dodaj JavaScript
Plugin URI: http://przyklad.pl/
Description: Pokazuje, jak prawidłowo wstawić kod JS na różnych stronach.
Author: Ozh
Author URI: http://wrox.com
*/

// Adres URL wskazujący podkatalog /js wtyczki.
define( 'BOJ_INSERTJS', plugin_dir_url( __FILE__).'js' );

// Dodanie nowych stron administracyjnych.
add_action('admin_menu', 'boj_insertjs_add_page');
function boj_insertjs_add_page() {
    // Dodanie skryptu JavaScript na wszystkich stronach administracyjnych.
    wp_enqueue_script( 'boj_insertjs_1', BOJ_INSERTJS.'/script.js.php?where=admin' );

    // Dodanie strony w menu Ustawienia
    $settings = add_options_page( 'Dodaj JS', 'Dodaj JS', 'manage_options',
        'boj_insertjs_settings', 'boj_insertjs_options_page'
    );
    
    // Dodanie skryptu JavaScript jedynie na stronie ustawień wtyczki.
    add_action( 'load-'.$settings, 'boj_insertjs_add_settings_script' );
    
    // Dodanie strony w menu Użytkownicy.
    $users = add_users_page( 'Dodaj JS', 'Dodaj JS', 'manage_options',
        'boj_insertjs_users', 'boj_insertjs_users_page'
    );
    
    // Dodanie skryptu JavaScript na stronie menu Użytkownicy przy użyciu innego zaczepu.
    add_action( 'admin_print_scripts-'.$users, 'boj_insertjs_add_users_script' );
}

// Dodanie skryptu JavaScript na stronie ustawień wtyczki.
function boj_insertjs_add_settings_script() {
    wp_enqueue_script( 'boj_insertjs_2', BOJ_INSERTJS.'/script.js.php?where=settings' );
}

// Dodanie skryptu JavaScript na stronie menu Użytkownicy, tym razem dla odmiany w stopce strony.
function boj_insertjs_add_users_script() {
    wp_enqueue_script( 'boj_insertjs_3', BOJ_INSERTJS.'/script.js.php?where=users',
        '', '', true
    );
}

// Dodanie skryptu JavaScript na stronie komentarzy.
add_action( 'load-edit-comments.php', 'boj_insertjs_on_comments' );
function boj_insertjs_on_comments() {
    wp_enqueue_script( 'boj_insertjs_4', BOJ_INSERTJS.'/script.js.php?where=comments' );
}


// Dodanie skryptu JavaScript na stronach bloga.
add_action( 'template_redirect', 'boj_insertjs_add_scripts_blog' );
function boj_insertjs_add_scripts_blog() {
    // Na wszystkich stronach bloga.
    wp_enqueue_script( 'boj_insertjs_5', BOJ_INSERTJS.'/script.js.php?where=blog' );
    
    // Tylko na stronach wyświetlających pojedynczy wpis bloga.
    if( is_single() ) {
        wp_enqueue_script( 'boj_insertjs_6', BOJ_INSERTJS.'/script.js.php?where=single' );
    }
    
    // Tylko na stronie „O mnie”.
    if( is_page('About') ) {
        wp_enqueue_script( 'boj_insertjs_7', BOJ_INSERTJS.'/script.js.php?where=about' );
    }
}


// Strona opcji.
function boj_insertjs_options_page() {
    ?>
    <div class="wrap">
    <?php screen_icon(); ?>
    <h2>Dodaj JavaScript</h2>
    
    <?php
    var_dump( plugin_basename( dirname(__FILE__) ) );
    var_dump( plugin_dir_url( __FILE__) );
    ?>
    
    <p>Ta przykładowa wtyczka powoduje dodanie różnych skryptów JS na wymienionych stronach:</p>
    <ol>
        <li>OBszar administracyjny:
        <ol>
            <li>Ta strona</li>
            <li>Strona wtyczki w menu Użytkownicy</li>
            <li>Strona Komentarze</li>
        </ol></li>
        <li>Blog:
        <ol>
            <li>Wszystkie strony bloga</li>
            <li>Strony zawierające pojedynczy wpis bloga</li>
        </ol></li>
    </ol>
    </div>
    <?php
}

// Strona dla użytkowników.
function boj_insertjs_users_page() {
    ?>
    <div class="wrap">
    <?php screen_icon(); ?>
    <h2>Dodaj JavaScript</h2>
    <p>To jest kolejna przykładowa strona. Tutaj kod JS został dodany w stopce (wyświetl źródło strony, aby się o tym przekonać).</p>
    </div>
    <?php
}

